/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import whocraft.tardis_refined.common.items.DimensionSamplerItem;
import whocraft.tardis_refined.common.items.DrillItem;
import whocraft.tardis_refined.common.items.GlassesItem;
import whocraft.tardis_refined.common.items.KeyItem;
import whocraft.tardis_refined.common.items.MalletItem;
import whocraft.tardis_refined.common.items.ScrewdriverItem;
import whocraft.tardis_refined.common.items.ZeitonIngotItem;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;
import whocraft.tardis_refined.registry.forge.TRItemRegistryImpl;

public class TRItemRegistry {
    public static final DeferredRegistry<CreativeModeTab> TABS = DeferredRegistry.create("tardis_refined", Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> MAIN_TAB = TABS.register("main_tab", TRItemRegistry::getCreativeTab);
    public static final DeferredRegistry<Item> ITEMS = DeferredRegistry.create("tardis_refined", Registries.f_256913_);
    public static List<RegistrySupplier<Item>> TAB_ITEMS = new ArrayList<RegistrySupplier<Item>>();
    public static final RegistrySupplier<Item> KEY = TRItemRegistry.register("tardis_key", () -> new KeyItem(new Item.Properties().m_41487_(1)), true);
    public static final RegistrySupplier<Item> SCREWDRIVER = TRItemRegistry.register("amethyst_screwdriver", () -> new ScrewdriverItem(new Item.Properties().m_41487_(1)), true);
    public static final RegistrySupplier<Item> PATTERN_MANIPULATOR = TRItemRegistry.register("pattern_manipulator", () -> new Item(new Item.Properties().m_41487_(1)), true);
    public static final RegistrySupplier<Item> DRILL = TRItemRegistry.register("drill", () -> new DrillItem(new Item.Properties().m_41487_(1)), true);
    public static final RegistrySupplier<Item> RAW_ZEITON = TRItemRegistry.register("raw_zeiton", () -> new Item(new Item.Properties()), true);
    public static final RegistrySupplier<ZeitonIngotItem> ZEITON_INGOT = TRItemRegistry.register("zeiton_ingot", () -> new ZeitonIngotItem(new Item.Properties()), true);
    public static final RegistrySupplier<Item> ZEITON_NUGGET = TRItemRegistry.register("zeiton_nugget", () -> new Item(new Item.Properties()), true);
    public static final RegistrySupplier<GlassesItem> GLASSES = TRItemRegistry.register("glasses", () -> new GlassesItem(new Item.Properties()), true);
    public static final RegistrySupplier<MalletItem> MALLET = TRItemRegistry.register("mallet", () -> new MalletItem(new Item.Properties().m_41487_(1).m_41503_(50)), true);
    public static final RegistrySupplier<DimensionSamplerItem> TEST_TUBE = TRItemRegistry.register("test_tube", () -> new DimensionSamplerItem(new Item.Properties().m_41487_(1)), true);

    private static <T extends Item> RegistrySupplier<T> register(String id, Supplier<T> itemSupplier, boolean addToTab) {
        RegistrySupplier<T> item = ITEMS.register(id, itemSupplier);
        if (addToTab) {
            TAB_ITEMS.add(item);
        }
        return item;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CreativeModeTab getCreativeTab() {
        return TRItemRegistryImpl.getCreativeTab();
    }
}

