/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.config;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public final class ConfigBuilder {
    public final ForgeConfigSpec.Builder specBuilder = new ForgeConfigSpec.Builder();
    @Nullable
    public final String fileName;

    public ConfigBuilder() {
        this.fileName = null;
    }

    public ConfigBuilder(String fileName) {
        this.fileName = fileName;
    }

    public ConfigBuilder comment(String comment) {
        this.specBuilder.comment(comment);
        return this;
    }

    public ConfigBuilder comment(String ... comment) {
        this.specBuilder.comment(comment);
        return this;
    }

    public void push(String name) {
        this.specBuilder.push(name);
    }

    public void pop() {
        this.specBuilder.pop();
    }

    public <T> ConfigValue<T> define(String path, T defaultValue) {
        return new ConfigValue(this.specBuilder.define(path, defaultValue));
    }

    public ConfigValue<Boolean> defineBoolean(String path, boolean defaultValue) {
        return new ConfigValue<Boolean>((ForgeConfigSpec.ConfigValue<Boolean>)this.specBuilder.define(path, defaultValue));
    }

    public ConfigValue<Integer> defineInt(String path, int defaultValue, int min, int max) {
        return new ConfigValue<Integer>((ForgeConfigSpec.ConfigValue<Integer>)this.specBuilder.defineInRange(path, defaultValue, min, max));
    }

    public ConfigValue<Double> defineDouble(String path, double defaultValue, double min, double max) {
        return new ConfigValue<Double>((ForgeConfigSpec.ConfigValue<Double>)this.specBuilder.defineInRange(path, defaultValue, min, max));
    }

    public ConfigValue<String> defineString(String path, String defaultValue) {
        return new ConfigValue<String>(this.specBuilder.define(path, (Object)defaultValue));
    }

    public <T extends Enum<T>> ConfigValue<T> DefineEnum(String path, T defaultValue) {
        return new ConfigValue(this.specBuilder.defineEnum(path, defaultValue));
    }

    public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue) {
        return this.defineList(path, defaultValue, it -> true);
    }

    public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> predicate) {
        return new ConfigValue<List<? extends T>>(this.specBuilder.defineListAllowEmpty(List.of(path), () -> new ArrayList(defaultValue), predicate));
    }

    public void buildClient(String modId) {
        Fragmentum.SERVICES.config().registerClient(modId, this);
    }

    public void buildCommon(String modId) {
        Fragmentum.SERVICES.config().registerCommon(modId, this);
    }

    public void buildServer(String modId) {
        Fragmentum.SERVICES.config().registerServer(modId, this);
    }
}

