/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.script.types;

import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public interface LuaOps<T> {
    public static final LuaOps<Integer> INT = LuaOps.nonnil(CoerceJavaToLua::coerce, LuaValue::toint);
    public static final LuaOps<Float> FLOAT = LuaOps.nonnil(CoerceJavaToLua::coerce, LuaValue::tofloat);
    public static final LuaOps<Double> DOUBLE = LuaOps.nonnil(CoerceJavaToLua::coerce, LuaValue::todouble);
    public static final LuaOps<Boolean> BOOL = LuaOps.nonnil(CoerceJavaToLua::coerce, LuaValue::toboolean);
    public static final LuaOps<String> STRING = LuaOps.nonnil(CoerceJavaToLua::coerce, LuaValue::toString);

    public LuaValue wrap(T var1);

    public T unwrap(LuaValue var1);

    public static <T> LuaOps<T> nonnil(final Wrapper<T> wrapper, final Unwrapper<T> unwrapper) {
        return new LuaOps<T>(){

            @Override
            public LuaValue wrap(T value) {
                return wrapper.wrap(value);
            }

            @Override
            public T unwrap(LuaValue value) {
                return unwrapper.unwrap(value);
            }
        };
    }

    public static <T> Nilable<T> nilable(final NilableWrapper<T> wrapper, final NilableUnwrapper<T> unwrapper) {
        return new Nilable<T>(){

            @Override
            public LuaValue wrap(@Nullable T value) {
                return wrapper.wrap(value);
            }

            @Override
            @Nullable
            public T unwrap(LuaValue value) {
                return unwrapper.unwrap(value);
            }
        };
    }

    @FunctionalInterface
    public static interface Wrapper<T> {
        public LuaValue wrap(T var1);
    }

    @FunctionalInterface
    public static interface Unwrapper<T> {
        public T unwrap(LuaValue var1);
    }

    @FunctionalInterface
    public static interface NilableWrapper<T> {
        public LuaValue wrap(@Nullable T var1);
    }

    @FunctionalInterface
    public static interface NilableUnwrapper<T> {
        @Nullable
        public T unwrap(LuaValue var1);
    }

    public static interface Nilable<T>
    extends LuaOps<T> {
        @Override
        public LuaValue wrap(@Nullable T var1);

        @Override
        @Nullable
        public T unwrap(LuaValue var1);
    }
}

