/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api;

import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.FTBChunksTags;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Protection {
    public static final Protection EDIT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        if (blockState.m_204336_(FTBChunksTags.Blocks.EDIT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        if (blockState.m_204336_(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection RIGHT_CLICK_ITEM = (player, pos, hand, chunk, entity) -> {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41614_() || Protection.isBeneficialPotion(stack) || stack.m_204117_(FTBChunksTags.Items.RIGHT_CLICK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && stack.m_204117_(FTBChunksTags.Items.RIGHT_CLICK_BLACKLIST_TAG)) {
            return ProtectionPolicy.DENY;
        }
        return ProtectionPolicy.ALLOW;
    };
    public static final Protection EDIT_FLUID = (player, pos, hand, chunk, entity) -> {
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.m_6095_().m_204039_(FTBChunksTags.Entities.ENTITY_INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.ENTITY_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection ATTACK_NONLIVING_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.m_6095_().m_204039_(FTBChunksTags.Entities.NONLIVING_ENTITY_ATTACK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.NONLIVING_ENTITY_ATTACK_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection EDIT_AND_INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        if (blockState.m_204336_(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_AND_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };

    public ProtectionPolicy getProtectionPolicy(ServerPlayer var1, BlockPos var2, InteractionHand var3, @Nullable ClaimedChunk var4, @Nullable Entity var5);

    public static boolean isBeneficialPotion(ItemStack stack) {
        return stack.m_41720_() instanceof PotionItem && PotionUtils.m_43547_((ItemStack)stack).stream().noneMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
    }
}

