/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import alabaster.hearthandharvest.common.registry.HHModBlocks;
import alabaster.hearthandharvest.common.registry.HHModItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class RedGrapeVineBlock
extends CropBlock {
    public static final IntegerProperty VINE_AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty ROPELOGGED = BooleanProperty.m_61465_((String)"ropelogged");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public RedGrapeVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isMature;
        int age = (Integer)state.m_61143_((Property)this.m_7959_());
        boolean bl = isMature = age == this.m_7419_();
        if (!isMature && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (isMature) {
            int quantity = 1 + level.f_46441_.m_188503_(2);
            RedGrapeVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)HHModItems.RED_GRAPES.get(), quantity));
            level.m_5594_(null, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9) {
            float speed;
            int age = this.m_52305_(state);
            if (age < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (speed = RedGrapeVineBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
            this.attemptRopeClimb(level, pos, random);
        }
    }

    public void attemptRopeClimb(ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188501_() < 0.3f) {
            boolean canClimb;
            BlockPos posAbove = pos.m_7494_();
            BlockState stateAbove = level.m_8055_(posAbove);
            boolean bl = canClimb = (Boolean)Configuration.ENABLE_TOMATO_VINE_CLIMBING_TAGGED_ROPES.get() != false ? stateAbove.m_204336_(ModTags.ROPES) : stateAbove.m_60713_((Block)ModBlocks.ROPE.get());
            if (canClimb) {
                int vineHeight = 1;
                while (level.m_8055_(pos.m_6625_(vineHeight)).m_60713_((Block)this)) {
                    ++vineHeight;
                }
                if (vineHeight < 3) {
                    level.m_46597_(posAbove, (BlockState)this.m_49966_().m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }

    public BlockState m_52289_(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age));
    }

    public IntegerProperty m_7959_() {
        return VINE_AGE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int m_7419_() {
        return 3;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)HHModItems.RED_GRAPES.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VINE_AGE, ROPELOGGED});
    }

    protected int m_7125_(Level level) {
        return super.m_7125_(level) / 2;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int maxAge;
        int newAge = this.m_52305_(state) + this.m_7125_((Level)level);
        if (newAge > (maxAge = this.m_7419_())) {
            newAge = maxAge;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge)));
        this.attemptRopeClimb(level, pos, random);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return (Boolean)state.m_61143_((Property)ROPELOGGED) != false && state.m_204336_(BlockTags.f_13082_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
            return belowState.m_60713_((Block)HHModBlocks.RED_GRAPE_CROP.get()) && this.hasGoodCropConditions(level, pos);
        }
        return super.m_7898_(state, level, pos);
    }

    public boolean hasGoodCropConditions(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        boolean isRopelogged = (Boolean)state.m_61143_((Property)ROPELOGGED);
        super.m_6240_(level, player, pos, state, blockEntity, stack);
        if (isRopelogged) {
            RedGrapeVineBlock.destroyAndPlaceRope(level, pos);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public static void destroyAndPlaceRope(Level level, BlockPos pos) {
        Block configuredRopeBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Configuration.DEFAULT_TOMATO_VINE_ROPE.get()));
        Block finalRopeBlock = configuredRopeBlock != null ? configuredRopeBlock : (Block)ModBlocks.ROPE.get();
        level.m_46597_(pos, finalRopeBlock.m_49966_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            if (((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
                RedGrapeVineBlock.destroyAndPlaceRope((Level)level, pos);
            }
        }
    }
}

