/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import vectorwing.farmersdelight.common.tag.ModTags;

public class SliceableCakeBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)6);
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};
    public final Supplier<Item> pieSlice;

    public SliceableCakeBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[(Integer)state.m_61143_((Property)BITES)];
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)this.pieSlice.get());
    }

    public int getMaxBites() {
        return 7;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_204117_(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.f_46443_) {
            if (this.consumeBite(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemStack sliceItem = this.getPieSliceItem();
        ItemEntity sliceEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5, sliceItem, (double)direction.m_122429_() * 0.15, 0.05, (double)direction.m_122431_() * 0.15);
        level.m_7967_((Entity)sliceEntity);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        ItemStack sliceCopy = sliceStack.m_41777_();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        ForgeEventFactory.onItemUseFinish((LivingEntity)playerIn, (ItemStack)sliceCopy, (int)0, (ItemStack)ItemStack.f_41583_);
        if (this.getPieSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }
}

