/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import alabaster.hearthandharvest.Config;
import alabaster.hearthandharvest.common.registry.HHModItems;
import alabaster.hearthandharvest.common.registry.HHModParticleTypes;
import alabaster.hearthandharvest.common.tag.HHModTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TreeTapperBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SAP = IntegerProperty.m_61631_((String)"sap", (int)0, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TreeTapperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SAP, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.NORTH) {
            return Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)10.0);
        }
        if (direction == Direction.EAST) {
            return Block.m_49796_((double)6.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
        }
        if (direction == Direction.SOUTH) {
            return Block.m_49796_((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0);
        }
        if (direction == Direction.WEST) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)13.0);
        }
        return null;
    }

    private boolean canAttachTo(BlockGetter level, BlockPos pos, Direction facing) {
        return level.m_8055_(pos).m_60783_(level, pos, facing);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.m_121945_(direction), direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = this.m_49966_();
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction)).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)SAP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SAP, WATERLOGGED});
        super.m_7926_(builder);
    }

    public int getMaxSap() {
        return 4;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState neighborState;
        if (level.f_46443_) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        float chance = 0.0f;
        if (direction.m_122434_().m_122479_() && (neighborState = level.m_8055_(pos.m_121945_(direction))).m_204336_(HHModTags.TAPPABLE)) {
            chance += ((Double)Config.TREE_TAPPER_BASE_CHANCE.get()).floatValue();
        }
        if (level.m_213780_().m_188501_() <= chance && ((Integer)state.m_61143_((Property)SAP)).intValue() != this.getMaxSap()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SAP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)SAP) + 1)), 3);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction;
        BlockPos tappablePos;
        BlockState tappableState;
        if (!level.f_46443_) {
            return;
        }
        if ((Integer)state.m_61143_((Property)SAP) < 4 && (tappableState = level.m_8055_(tappablePos = pos.m_121945_(direction = (Direction)state.m_61143_((Property)FACING)))).m_204336_(HHModTags.TAPPABLE) && random.m_188501_() < 0.1f) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.75;
            double z = (double)pos.m_123343_() + 0.5;
            double offset = 0.1;
            switch (direction) {
                case NORTH: {
                    z -= offset;
                    break;
                }
                case SOUTH: {
                    z += offset;
                    break;
                }
                case WEST: {
                    x -= offset;
                    break;
                }
                case EAST: {
                    x += offset;
                }
            }
            level.m_7106_((ParticleOptions)HHModParticleTypes.DRIPPING_SAP.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int sapLevel = (Integer)state.m_61143_((Property)SAP);
        if (sapLevel == 4 && player.m_21120_(hand).m_150930_(Items.f_42446_)) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            player.m_6674_(hand);
            level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemStack sapBucket = new ItemStack((ItemLike)HHModItems.SAP_BUCKET.get());
            player.m_36356_(sapBucket);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SAP, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!world.f_46443_) {
            world.m_186460_(pos, (Block)this, 100);
        }
    }
}

