/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block.entity;

import alabaster.hearthandharvest.common.block.CaskBlock;
import alabaster.hearthandharvest.common.block.entity.container.CaskMenu;
import alabaster.hearthandharvest.common.block.entity.inventory.CaskItemHandler;
import alabaster.hearthandharvest.common.crafting.CaskRecipe;
import alabaster.hearthandharvest.common.registry.HHModBlockEntities;
import alabaster.hearthandharvest.common.registry.HHModRecipeTypes;
import alabaster.hearthandharvest.common.utilities.HHTextUtils;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.utility.ItemUtils;

@Mod.EventBusSubscriber(modid="hearthandharvest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CaskBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
Nameable,
RecipeHolder {
    public static final int MEAL_DISPLAY_SLOT = 4;
    public static final int OUTPUT_SLOT = 4;
    public static final int INVENTORY_SIZE = 5;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CaskItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CaskItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int ageTime;
    private int ageTimeTotal;
    private Component customName;
    protected final ContainerData cookingPotData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<RecipeWrapper, CaskRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)HHModRecipeTypes.AGING.get()));

    public CaskBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HHModBlockEntities.CASK.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.ageTime = compound.m_128451_("CookTime");
        this.ageTimeTotal = compound.m_128451_("CookTimeTotal");
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.ageTime);
        compound.m_128405_("CookTimeTotal", this.ageTimeTotal);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CaskBlockEntity caskBlock) {
        boolean didInventoryChange = false;
        if (caskBlock.hasInput()) {
            Optional<CaskRecipe> recipe = caskBlock.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)caskBlock.inventory));
            if (recipe.isPresent() && caskBlock.canCook(recipe.get())) {
                didInventoryChange = caskBlock.processCooking(recipe.get(), caskBlock);
            } else {
                caskBlock.ageTime = 0;
            }
        } else if (caskBlock.ageTime > 0) {
            caskBlock.ageTime = Mth.m_14045_((int)(caskBlock.ageTime - 2), (int)0, (int)caskBlock.ageTimeTotal);
        }
        ItemStack mealStack = caskBlock.getMeal();
        if (!mealStack.m_41619_()) {
            caskBlock.moveMealToOutput();
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            caskBlock.inventoryChanged();
        }
    }

    private Optional<CaskRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.hasInput() ? this.quickCheck.m_213657_((Container)inventoryWrapper, this.f_58857_) : Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(CaskRecipe recipe) {
        if (this.hasInput()) {
            ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack storedMealStack = this.inventory.getStackInSlot(4);
            if (storedMealStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.m_41613_() + resultStack.m_41613_() <= this.inventory.getSlotLimit(4)) {
                return true;
            }
            return storedMealStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
        }
        return false;
    }

    public boolean isProcessingRecipe() {
        return this.ageTime > 0 && this.hasInput();
    }

    public int getCurrentLightLevel() {
        return this.f_58857_ != null ? this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) : 7;
    }

    public boolean processCooking(CaskRecipe recipe, CaskBlockEntity cask) {
        if (this.f_58857_ == null) {
            return false;
        }
        int baseCookTime = recipe.getCookTime();
        int lightLevel = this.getCurrentLightLevel();
        float effectiveMultiplier = lightLevel <= 5 ? 0.5f : (lightLevel <= 10 ? 1.0f : 2.0f);
        int effectiveCookTime = Math.max(1, (int)((float)baseCookTime * effectiveMultiplier));
        ++this.ageTime;
        this.ageTimeTotal = baseCookTime;
        if (this.ageTime < effectiveCookTime) {
            return false;
        }
        this.ageTime = 0;
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        ItemStack storedMealStack = this.inventory.getStackInSlot(4);
        if (storedMealStack.m_41619_()) {
            this.inventory.setStackInSlot(4, resultStack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        cask.m_6029_(recipe);
        for (int i = 0; i < 4; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)CaskBlock.FACING)).m_122428_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)this.f_58858_.m_123342_() + 0.7;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)remainderStack, (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                CaskBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((CaskRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(4);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 5; ++i) {
            if (i == 4) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(4);
        ItemStack outputStack = this.inventory.getStackInSlot(4);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(4, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : HHTextUtils.getTranslation("container.cask", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new CaskMenu(id, player, this, this.cookingPotData);
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                CaskBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> CaskBlockEntity.this.ageTime;
                    case 1 -> CaskBlockEntity.this.ageTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CaskBlockEntity.this.ageTime = value;
                        break;
                    }
                    case 1: {
                        CaskBlockEntity.this.ageTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }
}

