/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.crafting;

import alabaster.hearthandharvest.common.registry.HHModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class BottleCrateRecipe
extends CustomRecipe {
    private final Ingredient input;
    private final ItemStack result;

    public BottleCrateRecipe(ResourceLocation id, Ingredient input, ItemStack result) {
        super(id, CraftingBookCategory.MISC);
        this.input = input;
        this.result = result;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        if (inv.m_6643_() != 9) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack s = inv.m_8020_(i);
            if (!s.m_41619_() && this.input.test(s)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        return new ItemStack((ItemLike)this.result.m_41720_());
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122780_((int)9, (Object)this.input);
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return w >= 3 && h >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return HHModRecipeSerializers.BOTTLE_CRATE.get();
    }

    public boolean m_5598_() {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<BottleCrateRecipe> {
        public BottleCrateRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
            JsonObject resultJson = json.getAsJsonObject("result");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)resultJson, (boolean)true);
            return new BottleCrateRecipe(id, input, result);
        }

        public BottleCrateRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            return new BottleCrateRecipe(id, input, result);
        }

        public void toNetwork(FriendlyByteBuf buf, BottleCrateRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.result);
        }
    }
}

