/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.data;

import alabaster.hearthandharvest.data.BlockStates;
import alabaster.hearthandharvest.data.BlockTags;
import alabaster.hearthandharvest.data.ItemModels;
import alabaster.hearthandharvest.data.ItemTags;
import alabaster.hearthandharvest.data.Recipes;
import alabaster.hearthandharvest.data.loot.HHBlockLoot;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hearthandharvest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        BlockTags blockTags = new BlockTags(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(output, lookupProvider, blockTags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(output));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(HHBlockLoot::new, LootContextParamSets.f_81421_))));
        BlockStates blockStates = new BlockStates(output, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, blockStates.models().existingFileHelper));
    }
}

