/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.message;

import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.message.TemplateMessage;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.TimeService;
import net.lavabucket.hourglass.time.TimeServiceManager;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HourglassMessages {
    @SubscribeEvent
    public static void onSleepingCheckEvent(SleepingTimeCheckEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && event.getEntity().m_36318_() == 2 && event.getEntity().getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerLevel)service.level.get()).equals(event.getEntity().m_9236_()) && ((ServerLevel)service.level.get()).m_6907_().size() > 1 && service.level.daylightRuleEnabled()) {
            HourglassMessages.sendEnterBedMessage(new ServerPlayerWrapper(event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && event.updateLevel() && event.getEntity().getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerLevel)service.level.get()).equals(event.getEntity().m_9236_()) && ((ServerLevel)service.level.get()).m_6907_().size() > 1 && service.level.daylightRuleEnabled()) {
            HourglassMessages.sendLeaveBedMessage(new ServerPlayerWrapper(event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedEvent(SleepFinishedTimeEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && service != null && ((ServerLevel)service.level.get()).equals(event.getLevel()) && service.level.daylightRuleEnabled()) {
            ServerLevelWrapper level = new ServerLevelWrapper(event.getLevel());
            HourglassMessages.sendMorningMessage(level);
        }
    }

    public static void sendEnterBedMessage(ServerPlayerWrapper player) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.enterBedMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(((HourglassConfig.ChatTypeOptions)((Object)HourglassConfig.SERVER_CONFIG.enterBedMessageType.get())).isOverlay()).setVariable("player", ((ServerPlayer)player.get()).m_36316_().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.m_144009_())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.enterBedMessageTarget.get()), player.getLevel());
    }

    public static void sendLeaveBedMessage(ServerPlayerWrapper player) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.leaveBedMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(((HourglassConfig.ChatTypeOptions)((Object)HourglassConfig.SERVER_CONFIG.leaveBedMessageType.get())).isOverlay()).setVariable("player", ((ServerPlayer)player.get()).m_36316_().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.m_144009_() - 1)).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.leaveBedMessageTarget.get()), player.getLevel());
    }

    public static void sendMorningMessage(ServerLevelWrapper level) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.morningMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(((HourglassConfig.ChatTypeOptions)((Object)HourglassConfig.SERVER_CONFIG.morningMessageType.get())).isOverlay()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.m_144009_())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.morningMessageTarget.get()), level);
    }
}

