/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time;

import java.text.DecimalFormat;
import java.util.Comparator;

public class Time
extends Number
implements Comparable<Time> {
    public static final int DAY_TICKS = 24000;
    public static final int LUNAR_CYCLE_TICKS = 192000;
    public static final Time DAY_LENGTH = new Time(24000L);
    public static final Time LUNAR_CYCLE_LENGTH = new Time(192000L);
    public static final Time NOON = new Time(6000L);
    public static final Time MIDNIGHT = new Time(18000L);
    public static final Time MORNING = new Time(0L);
    private final long longPart;
    private final double fractionPart;

    public Time() {
        this.longPart = 0L;
        this.fractionPart = 0.0;
    }

    public Time(long time) {
        this.longPart = time;
        this.fractionPart = 0.0;
    }

    public Time(double time) {
        this(0L, time);
    }

    public Time(long longPart, double fractionPart) {
        long overflow = (long)fractionPart;
        if ((longPart += overflow) != 0L && (fractionPart -= (double)overflow) != 0.0 && longPart > 0L != fractionPart > 0.0) {
            if (longPart > 0L) {
                --longPart;
                fractionPart += 1.0;
            } else {
                ++longPart;
                fractionPart -= 1.0;
            }
        }
        this.longPart = longPart;
        this.fractionPart = fractionPart;
    }

    @Override
    public long longValue() {
        return this.longPart;
    }

    public double fractionalValue() {
        return this.fractionPart;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public double doubleValue() {
        return (double)this.longPart + this.fractionPart;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public Time timeOfDay() {
        return this.mod(24000L);
    }

    public static long timeOfDay(long time) {
        return time % 24000L;
    }

    public static boolean crossedMorning(Time a, Time b) {
        return a.getDay() != b.getDay();
    }

    public long getDay() {
        return this.longPart / 24000L;
    }

    public Time add(Time val) {
        return new Time(this.longPart + val.longPart, this.fractionPart + val.fractionPart);
    }

    public Time add(long val) {
        return new Time(this.longPart + val, this.fractionPart);
    }

    public Time add(double val) {
        return this.add(new Time(val));
    }

    public Time subtract(Time val) {
        return new Time(this.longPart - val.longPart, this.fractionPart - val.fractionPart);
    }

    public Time subtract(long val) {
        return new Time(this.longPart - val, this.fractionPart);
    }

    public Time subtract(double val) {
        return this.subtract(new Time(val));
    }

    public double divide(Time val) {
        return this.doubleValue() / val.doubleValue();
    }

    public double divide(double val) {
        return this.doubleValue() / val;
    }

    public double divide(long val) {
        return this.doubleValue() / (double)val;
    }

    public Time negate() {
        return new Time(-this.longPart, -this.fractionPart);
    }

    public Time abs() {
        return this.compareTo(new Time(0L, 0.0)) < 0 ? this.negate() : this;
    }

    public Time mod(long val) {
        return new Time(this.longPart % val, this.fractionPart);
    }

    public boolean betweenMod(Time a, Time b) {
        if (a.equals(b)) {
            return false;
        }
        if (a.compareTo(b) < 0) {
            return this.compareTo(a) > 0 && this.compareTo(b) < 0;
        }
        return this.compareTo(a) > 0 || this.compareTo(b) < 0;
    }

    @Override
    public int compareTo(Time other) {
        return Comparator.comparingLong(time -> time.longPart).thenComparingDouble(time -> time.fractionPart).compare(this, other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long fractionBits = Double.doubleToLongBits(this.fractionPart);
        result = 31 * result + (int)(this.longPart ^ this.longPart >>> 32);
        result = 31 * result + (int)(fractionBits ^ fractionBits >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        if (Double.doubleToLongBits(this.fractionPart) != Double.doubleToLongBits(other.fractionPart)) {
            return false;
        }
        return this.longPart == other.longPart;
    }

    public String toString() {
        if (this.fractionPart == 0.0) {
            return Long.toString(this.longPart);
        }
        if (this.longPart == 0L) {
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(6);
            df.setMinimumIntegerDigits(1);
            return df.format(this.fractionPart);
        }
        DecimalFormat df = new DecimalFormat("#");
        df.setMaximumFractionDigits(6);
        df.setMaximumIntegerDigits(0);
        return this.longPart + df.format(Math.abs(this.fractionPart));
    }
}

