/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import com.mojang.blaze3d.platform.NativeImage;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;

public class AtlasSprite {

    public static class Ticker
    implements SpriteTicker {
        private final SpriteContents spriteContents;
        private final SpriteContentsAccessor spriteContentsAccessor;
        private int lastAtlasId = -1;

        public Ticker(SpriteContents spriteContents) {
            this.spriteContents = spriteContents;
            this.spriteContentsAccessor = (SpriteContentsAccessor)spriteContents;
        }

        void upload(int x, int y, NativeImage[] atlasData) {
            for (int i = 0; i < atlasData.length; ++i) {
                atlasData[i].m_85003_(i, x >> i, y >> i, 0, 0, this.spriteContents.m_246492_() >> i, this.spriteContents.m_245330_() >> i, atlasData.length > 1, false);
            }
        }

        public void m_247697_(int x, int y) {
            if (this.lastAtlasId == DynamicAtlas.BAKED.getLastStateId()) {
                return;
            }
            if (DynamicAtlas.BAKED.getUsage() == 0.0f) {
                return;
            }
            this.lastAtlasId = DynamicAtlas.BAKED.getLastStateId();
            NativeImage source = DynamicAtlas.BAKED.m_117991_();
            assert (source != null);
            NativeImage[] content = this.spriteContentsAccessor.getMipLevelData();
            this.copyRect(source, content[0], 0, 0, this.spriteContents.m_246492_(), this.spriteContents.m_245330_());
            for (int i = 1; i < content.length; ++i) {
                this.mipTheMap(content[i - 1], content[i], 0, 0, this.spriteContents.m_246492_() >> i, this.spriteContents.m_245330_() >> i);
            }
            this.upload(x, y, content);
        }

        public void copyRect(NativeImage source, NativeImage destination, int xTo, int yTo, int width, int height) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int m = source.m_84985_(j, i);
                    destination.m_84988_(xTo + j, yTo + i, m);
                }
            }
        }

        static int blend(int ... colors) {
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            for (int c : colors) {
                r += c >> 16 & 0xFF;
                g += c >> 8 & 0xFF;
                b += c & 0xFF;
                a = Math.max(a, c >> 24 & 0xFF);
            }
            return a << 24 | (r /= colors.length) << 16 | (g /= colors.length) << 8 | (b /= colors.length);
        }

        public void mipTheMap(NativeImage source, NativeImage destination, int xTo, int yTo, int width, int height) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int m = Ticker.blend(source.m_84985_(j * 2, i * 2), source.m_84985_(j * 2 + 1, i * 2), source.m_84985_(j * 2, i * 2 + 1), source.m_84985_(j * 2 + 1, i * 2 + 1));
                    destination.m_84988_(xTo + j, yTo + i, m);
                }
            }
        }

        public void close() {
        }
    }
}

