/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.HashMap;
import java.util.List;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.RotatedMaterial;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public record MaterialSource(ResourceLocation location, RotatedMaterial down, RotatedMaterial up, RotatedMaterial north, RotatedMaterial south, RotatedMaterial west, RotatedMaterial east) {
    public static final MaterialSource DEFAULT = new MaterialSource(new ResourceLocation("minecraft:oak_log"), new RotatedMaterial("minecraft:block/oak_log_top"), new RotatedMaterial("minecraft:block/oak_log_top"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"));
    private static final RandomSource random = RandomSource.m_216327_();

    public NativeImage get(Direction direction) {
        return MaterialSource.getImage(this.getMaterial(direction).sprite());
    }

    public RotatedMaterial getMaterial(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.down;
            case Direction.UP -> this.up;
            case Direction.NORTH -> this.north;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.EAST -> this.east;
        };
    }

    public static NativeImage getImage(TextureAtlasSprite sprite) {
        return ((SpriteContentsAccessor)sprite.m_245424_()).getMipLevelData()[0];
    }

    public Component name() {
        String key = "block." + this.location.m_135827_() + "." + this.location.m_135815_();
        return Component.m_264568_((String)key, (String)Utils.capitalize(this.location));
    }

    public static MaterialSource create(BlockState state) {
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
        HashMap<Direction, RotatedMaterial> materials = new HashMap<Direction, RotatedMaterial>();
        for (Direction direction : Direction.values()) {
            int height;
            List quads = model.m_213637_(state, direction, random);
            if (quads.size() != 1) {
                return null;
            }
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
            int width = sprite.m_245424_().m_246492_();
            if (width != (height = sprite.m_245424_().m_245330_()) || Math.pow((int)Math.sqrt(width), 2.0) != (double)width) {
                return null;
            }
            int rotation = MaterialSource.getRotation(quads);
            ResourceLocation name = sprite.m_245424_().m_246162_();
            materials.put(direction, new RotatedMaterial(sprite.m_247685_(), name, rotation));
        }
        ResourceLocation name = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        return new MaterialSource(name, (RotatedMaterial)materials.get(Direction.DOWN), (RotatedMaterial)materials.get(Direction.UP), (RotatedMaterial)materials.get(Direction.NORTH), (RotatedMaterial)materials.get(Direction.SOUTH), (RotatedMaterial)materials.get(Direction.WEST), (RotatedMaterial)materials.get(Direction.EAST));
    }

    private static int getRotation(List<BakedQuad> quads) {
        int[] v = quads.get(0).m_111303_();
        float u0 = Float.intBitsToFloat(v[4]);
        float v0 = Float.intBitsToFloat(v[5]);
        float u1 = Float.intBitsToFloat(v[20]);
        float v1 = Float.intBitsToFloat(v[21]);
        int rotation = 0;
        if (u0 > u1) {
            rotation = v0 > v1 ? (rotation += 2) : (rotation += 3);
        } else if (v0 > v1) {
            ++rotation;
        }
        return rotation;
    }

    public static int wrap(int x, int w, int n) {
        if (w >= n) {
            return x + (w - n) / 2;
        }
        int cycleLength = 2 * w;
        int fullCycles = n / cycleLength;
        int remainder = n % cycleLength;
        int pos = x % (fullCycles * cycleLength + remainder);
        int block = pos / w;
        int offset = pos % w;
        return block % 2 == 0 ? offset : w - 1 - offset;
    }

    public static int smartWrap(int coord, int size, int textureSize, int margin) {
        if (coord < margin || coord >= size - margin) {
            return coord >= size / 2 ? textureSize - (size - coord) : coord;
        }
        int w = Math.max(1, textureSize - margin * 2);
        int n = Math.max(1, size - margin * 2);
        return MaterialSource.wrap(coord - margin, w, n) + margin;
    }

    public static int fromCube(FurnitureData.Material material, Direction direction, Vector3f center, int x, int y, int w, int h) {
        Direction rotatedDirection = direction;
        int axisOrdinal = material.axis.ordinal();
        if (axisOrdinal > 0) {
            int shift = 2 * axisOrdinal;
            int directionOrdinal = (direction.ordinal() + shift) % 6;
            rotatedDirection = Direction.values()[directionOrdinal];
        }
        MaterialSource source = MaterialRegistry.INSTANCE.materials.getOrDefault(material.source, DEFAULT);
        NativeImage texture = source.get(rotatedDirection);
        if (direction == Direction.EAST || direction == Direction.NORTH) {
            x = w - x - 1;
        }
        if (direction == Direction.DOWN) {
            y = h - y - 1;
        }
        if (material.wrap == FurnitureData.WrapMode.REPEAT) {
            x += (int)(center.x += center.y);
            y += (int)(center.z += center.y);
        }
        int tw = texture.m_84982_();
        int th = texture.m_85084_();
        if (material.wrap == FurnitureData.WrapMode.EXPAND) {
            x = MaterialSource.smartWrap(x, w, tw, material.margin);
            y = MaterialSource.smartWrap(y, h, th, material.margin);
        }
        x %= tw;
        y %= th;
        if (material.axis != FurnitureData.MaterialAxis.X && direction == Direction.NORTH) {
            x = tw - x - 1;
        }
        if (material.axis != FurnitureData.MaterialAxis.Y && direction == Direction.DOWN) {
            y = th - y - 1;
        }
        if (material.axis == FurnitureData.MaterialAxis.X && direction == Direction.EAST) {
            x = tw - x - 1;
        }
        int rotation = source.getMaterial(rotatedDirection).getRotation();
        if (material.axis == FurnitureData.MaterialAxis.Y) {
            switch (direction) {
                case DOWN: 
                case UP: 
                case SOUTH: {
                    ++rotation;
                    break;
                }
                case NORTH: {
                    rotation += 3;
                    break;
                }
                case EAST: {
                    rotation += 2;
                }
            }
        } else if (material.axis == FurnitureData.MaterialAxis.Z) {
            switch (direction) {
                case UP: {
                    rotation += 2;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    rotation += 3;
                    break;
                }
                case WEST: 
                case EAST: {
                    ++rotation;
                }
            }
        }
        if ((rotation %= 4) == 1) {
            int temp = x;
            x = y;
            y = tw - temp - 1;
        } else if (rotation == 2) {
            x = tw - x - 1;
            y = th - y - 1;
        } else if (rotation == 3) {
            int temp = x;
            x = th - y - 1;
            y = temp;
        }
        return texture.m_84985_(x, y);
    }
}

