/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ModelBoundingBoxFetcher {
    public static final ModelBoundingBoxFetcher INSTANCE = new ModelBoundingBoxFetcher();
    private final Map<Long, AABB> CACHE = new HashMap<Long, AABB>();
    private final RandomSource random = RandomSource.m_216327_();

    public AABB getModelBoundingBox(BakedModel bakedmodel) {
        long modelKey = System.identityHashCode(bakedmodel);
        return this.CACHE.computeIfAbsent(modelKey, k -> this.computeModelBoundingBox(bakedmodel));
    }

    private AABB computeModelBoundingBox(BakedModel bakedmodel) {
        float minX = 3.0f;
        float minY = 3.0f;
        float minZ = 3.0f;
        float maxX = -3.0f;
        float maxY = -3.0f;
        float maxZ = -3.0f;
        ItemTransform transform = bakedmodel.m_7442_().m_269404_(ItemDisplayContext.FIXED);
        PoseStack poseStack = new PoseStack();
        transform.m_111763_(false, poseStack);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        for (int d = 0; d < 7; ++d) {
            Direction direction = d == 6 ? null : Direction.m_122376_((int)d);
            List quads = bakedmodel.m_213637_(null, direction, this.random);
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() == Direction.SOUTH || quad.m_111306_() == Direction.NORTH) continue;
                int[] vertices = quad.m_111303_();
                for (int i = 0; i < 4; ++i) {
                    int offset = i * 8;
                    float x = Float.intBitsToFloat(vertices[offset]);
                    float y = Float.intBitsToFloat(vertices[offset + 1]);
                    float z = Float.intBitsToFloat(vertices[offset + 2]);
                    Vector4f pos = pose.transform(x, y, z, 1.0f, new Vector4f());
                    if (pos.x < minX) {
                        minX = pos.x;
                    }
                    if (pos.y < minY) {
                        minY = pos.y;
                    }
                    if (pos.z < minZ) {
                        minZ = pos.z;
                    }
                    if (pos.x > maxX) {
                        maxX = pos.x;
                    }
                    if (pos.y > maxY) {
                        maxY = pos.y;
                    }
                    if (!(pos.z > maxZ)) continue;
                    maxZ = pos.z;
                }
            }
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

