/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureRegistry;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureRegistryMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class ServerFurnitureRegistry {
    public static FurnitureRegistrySavedData getData(ServerLevel level) {
        return (FurnitureRegistrySavedData)level.m_7654_().m_129783_().m_8895_().m_164861_(FurnitureRegistrySavedData::new, FurnitureRegistrySavedData::new, "immersive_furniture");
    }

    public static void increase(ServerLevel level, FurnitureData data) {
        String hash = data.getHash();
        FurnitureRegistrySavedData registry = ServerFurnitureRegistry.getData(level);
        registry.usageCount.put(hash, registry.usageCount.getOrDefault(hash, 0) + 1);
        registry.m_77762_();
    }

    public static int registerIdentifier(ServerLevel level, FurnitureData data, int from, int to) {
        String hash = data.getHash();
        FurnitureRegistrySavedData saveData = ServerFurnitureRegistry.getData(level);
        if (saveData.registry.hashToIdentifier.containsKey(hash)) {
            return saveData.registry.hashToIdentifier.get(hash);
        }
        int count = saveData.usageCount.getOrDefault(hash, 0);
        if (count < Config.getInstance().lowMemoryModeThreshold) {
            return -1;
        }
        for (int identifier = from; identifier <= to; ++identifier) {
            if (saveData.registry.identifierToHash.containsKey(identifier)) continue;
            saveData.registry.hashToIdentifier.put(hash, identifier);
            saveData.registry.identifierToHash.put(identifier, hash);
            saveData.m_77762_();
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(Map.of(identifier, hash));
            for (ServerPlayer player : level.m_6907_()) {
                Network.sendToPlayer(message, player);
            }
            return identifier;
        }
        return -1;
    }

    public static void syncWithPlayer(ServerPlayer player) {
        int chunkSize = 128;
        FurnitureRegistrySavedData savedData = ServerFurnitureRegistry.getData(player.m_284548_());
        HashMap<Integer, String> subMap = new HashMap<Integer, String>();
        for (String hash : savedData.registry.hashToIdentifier.keySet()) {
            int identifier = savedData.registry.hashToIdentifier.get(hash);
            subMap.put(identifier, hash);
            if (subMap.size() < chunkSize) continue;
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
            subMap.clear();
        }
        if (!subMap.isEmpty()) {
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
        }
    }

    public static class FurnitureRegistrySavedData
    extends SavedData {
        final Map<String, Integer> usageCount = new HashMap<String, Integer>();
        final FurnitureRegistry registry = FurnitureRegistry.INSTANCE;

        public FurnitureRegistrySavedData() {
        }

        public FurnitureRegistrySavedData(CompoundTag nbt) {
            CompoundTag usageCountTag = nbt.m_128469_("usageCount");
            usageCountTag.m_128431_().forEach(key -> this.usageCount.put((String)key, usageCountTag.m_128451_(key)));
            CompoundTag hashToIdentifierTag = nbt.m_128469_("hashToIdentifier");
            hashToIdentifierTag.m_128431_().forEach(key -> {
                this.registry.hashToIdentifier.put((String)key, hashToIdentifierTag.m_128451_(key));
                this.registry.identifierToHash.put(hashToIdentifierTag.m_128451_(key), (String)key);
            });
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            CompoundTag usageCountTag = new CompoundTag();
            this.usageCount.forEach((arg_0, arg_1) -> ((CompoundTag)usageCountTag).m_128405_(arg_0, arg_1));
            nbt.m_128365_("usageCount", (Tag)usageCountTag);
            CompoundTag hashToIdentifierTag = new CompoundTag();
            this.registry.hashToIdentifier.forEach((arg_0, arg_1) -> ((CompoundTag)hashToIdentifierTag).m_128405_(arg_0, arg_1));
            nbt.m_128365_("hashToIdentifier", (Tag)hashToIdentifierTag);
            return nbt;
        }
    }
}

