/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.network.s2c;

import net.conczin.immersive_furniture.InteractionManager;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;

public record PoseOffsetMessage(BlockPos blockPos, Vector3f offset, Pose pose, float rotation, int entityId) implements ImmersivePayload
{
    public PoseOffsetMessage(BlockPos blockPos, FurnitureData.PoseOffset poseOffset, Entity entity) {
        this(blockPos, poseOffset.offset(), poseOffset.pose(), poseOffset.rotation(), entity.m_19879_());
    }

    public PoseOffsetMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), (Pose)buf.m_130066_(Pose.class), buf.readFloat(), buf.readInt());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeFloat(this.offset.x());
        buf.writeFloat(this.offset.y());
        buf.writeFloat(this.offset.z());
        buf.m_130068_((Enum)this.pose);
        buf.writeFloat(this.rotation);
        buf.writeInt(this.entityId);
    }

    @Override
    public void handle(Player player) {
        FurnitureData.PoseOffset poseOffset = new FurnitureData.PoseOffset(this.offset, this.pose, this.rotation);
        Entity entity = player.m_9236_().m_6815_(this.entityId);
        if (entity != null && entity != player) {
            InteractionManager.INSTANCE.addInteraction(entity, this.blockPos, poseOffset);
        }
    }
}

