/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_machinery.Common;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.entity.NavigatingMachine;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BambooBee
extends NavigatingMachine {
    private Configuration configuration = new Configuration();
    private final List<ContainerPosition> containerPositions = new LinkedList<ContainerPosition>();
    private Task currentTask;
    private int searchCooldown = 0;
    public static final int WORK_SLOT = 0;

    public BambooBee(EntityType<? extends MachineEntity> entityType, Level world) {
        super(entityType, world, false, true, 1);
    }

    protected SoundEvent getEngineSound() {
        return Sounds.BAMBOO_BEE.get();
    }

    protected float getEnginePitch() {
        float speed = (float)this.getSpeedVector().m_82553_();
        return 0.65f + speed * 1.25f;
    }

    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            double dx = this.x - this.secondLastX;
            double dy = this.y - this.secondLastY;
            double dz = this.z - this.secondLastZ;
            double d2 = dx * dx + dy * dy + dz * dz;
            if (d2 > 0.0 && d2 < 10.0) {
                float yRot = this.m_146908_();
                this.m_146926_(Utils.lerpAngle(this.m_146909_(), (float)(dy * 45.0), 2.0f));
                this.m_146922_(Utils.lerpAngle(yRot, (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f, 8.0f));
                this.setZRot(Utils.lerpAngle(this.getRoll(), (this.m_146908_() - yRot) * 2.0f, 2.0f));
                if (this.m_9236_().m_46467_() % 4L == 0L) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.x, this.y + 0.4, this.z, 0.0, 0.0, 0.0);
                }
            } else {
                this.m_146926_(Utils.lerpAngle(this.m_146909_(), 0.0f, 5.0f));
                this.setZRot(Utils.lerpAngle(this.getRoll(), 0.0f, 5.0f));
            }
            return;
        }
        this.setEngineTarget(this.currentTask != null ? 1.0f : 0.0f);
        if (this.currentTask == null) {
            --this.searchCooldown;
            if (this.searchCooldown <= 0) {
                this.currentTask = this.getTask();
                if (this.currentTask == null) {
                    this.searchCooldown = 60;
                }
            }
        } else {
            ItemStack carries = this.m_141942_(0).m_142196_();
            if (carries.m_41619_()) {
                if (this.moveTowards(this.currentTask.source())) {
                    BlockEntity blockEntity = this.m_9236_().m_7702_(this.currentTask.source());
                    if (blockEntity instanceof Container) {
                        Container container = (Container)blockEntity;
                        ItemStack item = container.m_8020_(this.currentTask.slot());
                        if (this.match(item, this.currentTask.stack())) {
                            ItemStack stack = container.m_7407_(this.currentTask.slot(), item.m_41613_());
                            this.m_141942_(0).m_142104_(stack);
                            this.m_216990_(SoundEvents.f_11725_);
                            blockEntity.m_6596_();
                        } else {
                            this.error("Item mismatches!");
                            this.currentTask = null;
                        }
                    } else {
                        this.error("Container gone!");
                        this.currentTask = null;
                    }
                }
            } else if (this.match(carries, this.currentTask.stack())) {
                if (this.moveTowards(this.currentTask.target())) {
                    BlockEntity blockEntity = this.m_9236_().m_7702_(this.currentTask.target());
                    if (blockEntity instanceof Container) {
                        Container container = (Container)blockEntity;
                        this.addToContainer(container, carries);
                        this.m_216990_(SoundEvents.f_11724_);
                        blockEntity.m_6596_();
                        if (carries.m_41619_()) {
                            this.currentTask = null;
                        } else {
                            this.returnItem();
                        }
                    } else {
                        this.error("Container gone!");
                        this.currentTask = null;
                    }
                }
            } else {
                this.error("Wrong item, returning to source!");
                this.returnItem();
            }
        }
    }

    public boolean m_20160_() {
        return true;
    }

    protected void m_20157_() {
    }

    private void addToContainer(Container container, ItemStack carries) {
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (!container.m_7013_(slot, carries)) continue;
            if (ItemStack.m_150942_((ItemStack)carries, (ItemStack)stack)) {
                int count = Math.min(carries.m_41613_(), stack.m_41741_() - stack.m_41613_());
                stack.m_41769_(count);
                carries.m_41774_(count);
                container.m_6836_(slot, stack);
                continue;
            }
            if (!stack.m_41619_()) continue;
            container.m_6836_(slot, carries.m_278832_());
        }
    }

    private void returnItem() {
        ItemStack carries = this.m_141942_(0).m_142196_();
        this.currentTask = new Task(this.currentTask.source(), this.currentTask.slot(), carries.m_41777_(), this.currentTask.source());
    }

    private void error(String message) {
        MutableComponent error = Component.m_237115_((String)"entity.immersive_machinery.bamboo_bee").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)message));
        this.m_9236_().m_6907_().stream().filter((? super T player) -> player.m_20280_((Entity)this) < 64.0).forEach(player -> player.m_5661_((Component)error, false));
    }

    private List<ContainerPosition> getPositions(boolean input) {
        LinkedList<ContainerPosition> positions = new LinkedList<ContainerPosition>();
        for (ContainerPosition position : this.containerPositions) {
            if (position.input() != input) continue;
            positions.add(position);
        }
        if (this.configuration.order == Configuration.Order.ROUND_ROBIN) {
            Collections.rotate(positions, (int)this.m_9236_().m_46467_());
        }
        return positions;
    }

    private Task getTask() {
        for (ContainerPosition position : this.getPositions(true)) {
            BlockEntity blockEntity = this.m_9236_().m_7702_(position.pos());
            if (!(blockEntity instanceof Container)) continue;
            Container container = (Container)blockEntity;
            for (int slot = 0; slot < container.m_6643_(); ++slot) {
                Task task;
                ItemStack item = container.m_8020_(slot);
                if (item.m_41619_() || !container.m_271862_(container, slot, item) || !this.filter(item) || (task = this.findTask(position.pos(), slot, item)) == null) continue;
                return task;
            }
        }
        return null;
    }

    private Task findTask(BlockPos source, int slot, ItemStack item) {
        for (ContainerPosition position : this.getPositions(false)) {
            Container container;
            BlockEntity blockEntity = this.m_9236_().m_7702_(position.pos());
            if (!(blockEntity instanceof Container) || !this.couldMove(item, container = (Container)blockEntity)) continue;
            return new Task(source, slot, item.m_41777_(), position.pos());
        }
        return null;
    }

    private boolean couldMove(ItemStack item, Container container) {
        int count = item.m_41613_();
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (!container.m_7013_(slot, item)) continue;
            if (ItemStack.m_150942_((ItemStack)item, (ItemStack)stack)) {
                count -= stack.m_41741_() - stack.m_41613_();
            } else if (stack.m_41619_()) {
                count -= item.m_41741_();
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    private boolean filter(ItemStack stack) {
        List slots = this.getSlots(Common.SLOT_FILTER);
        return this.isEmpty(slots) || slots.stream().anyMatch(other -> this.match(stack, (ItemStack)other));
    }

    private boolean isEmpty(List<ItemStack> slots) {
        return slots.stream().allMatch(ItemStack::m_41619_);
    }

    private boolean match(ItemStack stack, ItemStack other) {
        if (this.configuration.compareTag) {
            return ItemStack.m_150942_((ItemStack)stack, (ItemStack)other);
        }
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)other);
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.writeConfiguration(tag);
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.readConfiguration(tag);
    }

    protected void addItemTag(@NotNull CompoundTag tag) {
        super.addItemTag(tag);
        this.writeConfiguration(tag);
    }

    protected void readItemTag(@NotNull CompoundTag tag) {
        super.readItemTag(tag);
        this.readConfiguration(tag);
    }

    private void readConfiguration(CompoundTag tag) {
        if (tag.m_128441_("ContainerPositions")) {
            ListTag list = tag.m_128437_("ContainerPositions", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag containerTag = list.m_128728_(i);
                this.containerPositions.add(ContainerPosition.fromTag(containerTag));
            }
        }
        this.configuration.read(tag);
    }

    private void writeConfiguration(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ContainerPosition position : this.containerPositions) {
            list.add((Object)position.toTag());
        }
        tag.m_128365_("ContainerPositions", (Tag)list);
        this.configuration.write(tag);
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"grabber", (float)(this.getInventory().m_8020_(0).m_41619_() ? -45.0f : 0.0f));
    }

    public Item asItem() {
        return Items.BAMBOO_BEE.get();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static class Configuration {
        public boolean blacklist;
        public boolean compareTag;
        public Order order = Order.ROUND_ROBIN;
        private boolean dirty;

        public void read(CompoundTag tag) {
            if (tag.m_128441_("Order")) {
                this.blacklist = tag.m_128471_("Blacklist");
                this.compareTag = tag.m_128471_("CompareTag");
                this.order = Order.valueOf(tag.m_128461_("Order"));
            }
        }

        public void write(CompoundTag tag) {
            tag.m_128379_("Blacklist", this.blacklist);
            tag.m_128379_("CompareTag", this.compareTag);
            tag.m_128359_("Order", this.order.name());
        }

        public void setDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void encode(FriendlyByteBuf b) {
            b.writeBoolean(this.blacklist);
            b.writeBoolean(this.compareTag);
            b.m_130068_((Enum)this.order);
        }

        public void decode(FriendlyByteBuf b) {
            this.blacklist = b.readBoolean();
            this.compareTag = b.readBoolean();
            this.order = (Order)b.m_130066_(Order.class);
        }

        public static enum Order {
            FIRST,
            ROUND_ROBIN;


            public Order next() {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case FIRST -> ROUND_ROBIN;
                    case ROUND_ROBIN -> FIRST;
                };
            }
        }
    }

    public record Task(BlockPos source, int slot, ItemStack stack, BlockPos target) {
    }

    public record ContainerPosition(BlockPos pos, String name, boolean input) {
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("pos", this.getPos());
            tag.m_128359_("name", this.name());
            tag.m_128379_("input", this.input());
            return tag;
        }

        public static ContainerPosition fromTag(CompoundTag tag) {
            BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_("pos"));
            String name = tag.m_128461_("name");
            boolean input = tag.m_128471_("input");
            return new ContainerPosition(pos, name, input);
        }

        public long getPos() {
            return this.pos().m_121878_();
        }
    }
}

