/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.item;

import immersive_aircraft.item.VehicleItem;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.item.MachineryItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooBeeItem
extends MachineryItem {
    public static final String TAG = "ContainerPositions";

    public BambooBeeItem(Item.Properties settings, VehicleItem.VehicleConstructor constructor) {
        super(settings, constructor);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        ListTag positions = this.getPositions(stack);
        if (positions.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.tooltip.help1"));
            tooltip.add((Component)Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.tooltip.help2"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"gui.immersive_machinery.bamboo_bee.tooltip.header", (Object[])new Object[]{positions.size()}));
            for (int i = 0; i < positions.size(); ++i) {
                CompoundTag tag = positions.m_128728_(i);
                String name = tag.m_128461_("name");
                boolean input = tag.m_128471_("input");
                String key = "gui.immersive_machinery.bamboo_bee.tooltip." + (input ? "input" : "output");
                tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237115_((String)name)}).m_130940_(input ? ChatFormatting.GREEN : ChatFormatting.AQUA));
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (context.m_7078_()) {
            if (!context.m_43725_().m_5776_()) {
                if (blockEntity instanceof Container) {
                    String name = BuiltInRegistries.f_256975_.m_7981_((Object)blockEntity.m_58900_().m_60734_()).m_214296_("block");
                    this.recordPosition(context.m_43722_(), context.m_8083_(), context.m_43723_(), name);
                } else {
                    this.getPositions(context.m_43722_()).clear();
                    this.send("positions_cleared", context.m_43723_(), ChatFormatting.GOLD);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private void recordPosition(ItemStack stack, BlockPos pos, Player player, String name) {
        this.get(stack, pos).ifPresentOrElse(containerTag -> {
            if (containerTag.m_128471_("input")) {
                containerTag.m_128379_("input", false);
                this.send("position_output", player, ChatFormatting.GREEN);
            } else {
                this.remove(stack, pos);
                this.send("position_removed", player, ChatFormatting.GRAY);
            }
        }, () -> {
            this.add(stack, pos, name);
            this.send("position_input", player, ChatFormatting.AQUA);
        });
    }

    private void send(String message, Player player, ChatFormatting formatting) {
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)("gui.immersive_machinery.bamboo_bee." + message)).m_130940_(formatting));
        }
    }

    private ListTag getPositions(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG)) {
            tag.m_128365_(TAG, (Tag)new ListTag());
        }
        return tag.m_128437_(TAG, 10);
    }

    private void add(ItemStack stack, BlockPos pos, String name) {
        CompoundTag tag = new BambooBee.ContainerPosition(pos, name, true).toTag();
        this.getPositions(stack).add((Object)tag);
    }

    private Optional<CompoundTag> get(ItemStack stack, BlockPos pos) {
        ListTag list = this.getPositions(stack);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (tag.m_128454_("pos") != pos.m_121878_()) continue;
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    private void remove(ItemStack stack, BlockPos pos) {
        ListTag list = this.getPositions(stack);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (tag.m_128454_("pos") != pos.m_121878_()) continue;
            list.remove(i);
            return;
        }
    }
}

