/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public enum InventoryHandler {
    INSTANCE;

    private final Method mergeStack = this.getMergeStackMethod();
    static final Map<Container, ImmutableList<Container>> preferredOrders;
    static final ResourceLocation DUMMY_PLAYER_CONTAINER;

    private Method getMergeStackMethod() {
        Method m = ObfuscationReflectionHelper.findMethod(AbstractContainerMenu.class, (String)"m_38903_", (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        m.setAccessible(true);
        return m;
    }

    public boolean mergeStack(AbstractContainerMenu container, ItemStack stack, int low, int high, boolean rev) {
        try {
            return (Boolean)this.mergeStack.invoke((Object)container, stack, low, high, rev);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getItemStack(ContainerContext ctx) {
        return this.getItemStack(ctx.slot);
    }

    public ItemStack getItemStack(Slot slot) {
        if (slot.getSlotIndex() < 0) {
            return ItemStack.f_41583_;
        }
        return slot.m_7993_();
    }

    public void moveItemToOtherInventory(ContainerContext ctx, ItemStack is, int targetLow, int targetHigh, boolean slotIsDestination) {
        for (int i = targetLow; !(i >= targetHigh || ctx.player.f_36096_.m_38853_(i).m_5857_(is) && this.mergeStack(ctx.player.f_36096_, is, i, i + 1, slotIsDestination)); ++i) {
        }
    }

    Slot findStackWithItem(ItemStack is, ContainerContext ctx) {
        if (is.m_41741_() == 1) {
            return null;
        }
        List<Map.Entry<Container, InventoryMapping>> entries = this.getSortedMapping(ctx);
        for (Map.Entry<Container, InventoryMapping> ent : entries) {
            Container inv = ent.getKey();
            if (inv == ctx.slotMapping.inv) continue;
            for (int i = ent.getValue().begin; i <= ent.getValue().end; ++i) {
                ItemStack sis;
                Slot slot = ctx.player.f_36096_.m_38853_(i);
                if (!slot.m_8010_((Player)ctx.player) || (sis = slot.m_7993_()) == null || sis.m_41720_() != is.m_41720_() || !ItemStack.m_150942_((ItemStack)sis, (ItemStack)is)) continue;
                return slot;
            }
        }
        return null;
    }

    List<Map.Entry<Container, InventoryMapping>> getSortedMapping(ContainerContext ctx) {
        ArrayList entries = Lists.newArrayList((Iterable)ctx.mapping.entrySet());
        if (preferredOrders.containsKey(ctx.slotMapping.inv)) {
            Collections.sort(entries, (o1, o2) -> {
                int idx1 = preferredOrders.get(ctx.slotMapping.inv).indexOf(o1.getKey());
                int idx2 = preferredOrders.get(ctx.slotMapping.inv).indexOf(o2.getKey());
                return Ints.compare((int)idx1, (int)idx2);
            });
        }
        return entries;
    }

    public Multiset<ItemStackHolder> getInventoryContent(ContainerContext context) {
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        TreeMultiset itemcounts = TreeMultiset.create((Comparator)new ItemStackComparator());
        for (int i = slotLow; i < slotHigh; ++i) {
            ItemStack stack;
            Slot slot = context.player.f_36096_.m_38853_(i);
            if (!slot.m_8010_((Player)context.player) || (stack = slot.m_7993_()).m_41619_()) continue;
            ItemStackHolder ish = new ItemStackHolder(stack.m_41777_());
            itemcounts.add((Object)ish, stack.m_41613_());
        }
        HashMultiset entries = HashMultiset.create();
        for (Multiset.Entry entry : itemcounts.descendingMultiset().entrySet()) {
            entries.add((Object)((ItemStackHolder)entry.getElement()), entry.getCount());
        }
        return entries;
    }

    static ResourceLocation lookupContainerTypeName(AbstractContainerMenu container) {
        return container instanceof InventoryMenu ? DUMMY_PLAYER_CONTAINER : BuiltInRegistries.f_256818_.m_7981_((Object)container.m_6772_());
    }

    static {
        preferredOrders = ImmutableMap.of((Object)ContainerContext.PLAYER_HOTBAR, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_OFFHAND, (Object)ContainerContext.PLAYER_MAIN), (Object)ContainerContext.PLAYER_OFFHAND, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_HOTBAR, (Object)ContainerContext.PLAYER_MAIN), (Object)ContainerContext.PLAYER_MAIN, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_OFFHAND, (Object)ContainerContext.PLAYER_HOTBAR));
        DUMMY_PLAYER_CONTAINER = new ResourceLocation("inventorysorter:dummyplayercontainer");
    }

    public static class InventoryMapping {
        int begin = Integer.MAX_VALUE;
        int end = 0;
        final Container inv;
        final Container proxy;
        final AbstractContainerMenu container;
        final Slot slot;
        boolean markForRemoval;
        boolean markAsHeterogeneous;

        InventoryMapping(Container inv, AbstractContainerMenu container, Container proxy, Slot slot) {
            this.inv = inv;
            this.container = container;
            this.proxy = proxy;
            this.slot = slot;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("i", (Object)this.inv).add("c", (Object)this.container).add("b", this.begin).add("e", this.end).toString();
        }

        void addSlot(Slot sl) {
            if (!(this.slot.getClass() == sl.getClass() || this.inv instanceof Inventory || this.inv instanceof FurnaceBlockEntity || this.inv instanceof BrewingStandBlockEntity)) {
                this.markForRemoval = true;
            }
            if (this.slot.getClass() != sl.getClass()) {
                this.markAsHeterogeneous = true;
            }
            this.begin = Math.min(sl.f_40219_, this.begin);
            this.end = Math.max(sl.f_40219_, this.end);
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStackHolder> {
        @Override
        public int compare(ItemStackHolder o1, ItemStackHolder o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.is == o2.is) {
                return 0;
            }
            if (o1.is.m_41720_() != o2.is.m_41720_()) {
                return ItemStackComparator.compareString(o1.is).compareTo(ItemStackComparator.compareString(o2.is));
            }
            if (ItemStack.m_150942_((ItemStack)o1.is, (ItemStack)o2.is)) {
                return 0;
            }
            return Ints.compare((int)System.identityHashCode(o1.is), (int)System.identityHashCode(o2.is));
        }

        private static String compareString(ItemStack stack) {
            return String.valueOf(stack.m_220173_().m_203439_().map(ResourceKey::m_135782_, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)));
        }
    }
}

