/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.jadensnetherexpansiondelight.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="jadensnetherexpansiondelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ImmunityEvent {
    private static final Map<ResourceLocation, Set<MobEffect>> IMMUNITIES = new HashMap<ResourceLocation, Set<MobEffect>>();

    @SubscribeEvent
    public static void onImmunityEffect(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (entity == null || effectInstance == null) {
            return;
        }
        MobEffect effect = effectInstance.m_19544_();
        for (MobEffectInstance instance : entity.m_21220_()) {
            for (Map.Entry<ResourceLocation, Set<MobEffect>> entry : IMMUNITIES.entrySet()) {
                ResourceLocation resourceLocation = entry.getKey();
                MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(resourceLocation);
                if (mobEffect == null || instance.m_19544_() != mobEffect || !entry.getValue().contains(effect)) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    static {
        IMMUNITIES.put(new ResourceLocation("netherexp", "speed_immunity"), Set.of(MobEffects.f_19596_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "slowness_immunity"), Set.of(MobEffects.f_19597_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "strength_immunity"), Set.of(MobEffects.f_19600_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "jump_boost_immunity"), Set.of(MobEffects.f_19603_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "regeneration_immunity"), Set.of(MobEffects.f_19605_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "fire_resistance_immunity"), Set.of(MobEffects.f_19607_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "water_breathing_immunity"), Set.of(MobEffects.f_19608_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "invisibility_immunity"), Set.of(MobEffects.f_19609_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "weakness_immunity"), Set.of(MobEffects.f_19613_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "poison_immunity"), Set.of(MobEffects.f_19614_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "resistance_immunity"), Set.of(MobEffects.f_19606_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "absorption_immunity"), Set.of(MobEffects.f_19617_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "haste_immunity"), Set.of(MobEffects.f_19598_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "mining_fatigue_immunity"), Set.of(MobEffects.f_19599_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "darkness_immunity"), Set.of(MobEffects.f_216964_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "levitation_immunity"), Set.of(MobEffects.f_19620_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "hunger_immunity"), Set.of(MobEffects.f_19612_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "wither_immunity"), Set.of(MobEffects.f_19615_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "luck_immunity"), Set.of(MobEffects.f_19621_));
        IMMUNITIES.put(new ResourceLocation("netherexp", "unluck_immunity"), Set.of(MobEffects.f_19590_));
    }
}

