/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import dev.lucaargolo.mekanismcovers.CoverItem;
import dev.lucaargolo.mekanismcovers.CoverRecipe;
import dev.lucaargolo.mekanismcovers.EmptyCoverItem;
import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="mekanismcovers")
public class MekanismCovers {
    public static final String MODID = "mekanismcovers";
    public static final ModelProperty<BlockState> COVER_STATE = new ModelProperty();
    public static final ModelProperty<ModelData> COVER_DATA = new ModelProperty();
    public static final Map<BlockPos, BlockState> POSSIBLE_BLOCKS = new HashMap<BlockPos, BlockState>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mekanismcovers");
    public static final RegistryObject<Item> EMPTY_COVER = ITEMS.register("empty_cover", () -> new EmptyCoverItem(new Item.Properties()));
    public static final RegistryObject<Item> COVER = ITEMS.register("cover", () -> new CoverItem(new Item.Properties()));
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"mekanismcovers");
    public static final RegistryObject<RecipeSerializer<CoverRecipe>> COVER_SERIALIZER = RECIPE_SERIALIZERS.register("crafting_special_cover", () -> new SimpleCraftingRecipeSerializer(CoverRecipe::new));
    public static final ResourceLocation COVER_MODEL = new ResourceLocation("mekanismcovers", "block/cover");

    public MekanismCovers() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(EMPTY_COVER);
        }
    }

    public static void removeCover(Level world, BlockEntity tile, BlockState state, BlockPos pos, TileEntityTransmitterMixed transmitter, boolean update) {
        BlockState coverState = transmitter.mekanism_covers$getCoverState();
        ItemStack blockItemStack = coverState.m_60734_().m_5456_().m_7968_();
        ItemStack currentStack = new ItemStack((ItemLike)COVER.get());
        currentStack.m_41784_().m_128365_("CoverBlockItem", (Tag)blockItemStack.m_41739_(new CompoundTag()));
        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)currentStack);
        if (update) {
            transmitter.mekanism_covers$setCoverState(null);
            tile.m_6596_();
            world.m_7260_(pos, state, state, 3);
            world.m_5518_().m_7174_(pos);
            PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(pos)).send((Packet)new ClientboundLightUpdatePacket(new ChunkPos(pos), world.m_5518_(), null, null));
        }
    }
}

