/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.ElectricBurnerBlockEntity;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.dragonegg.moreburners.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ElectricBurnerBlock
extends BaseBurnerBlock {
    public static final BooleanProperty UPGRADED = BooleanProperty.m_61465_((String)"upgraded");
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.m_49796_((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});

    public ElectricBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)UPGRADED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UPGRADED});
    }

    public BlockState getState(BlazeBurnerBlock.HeatLevel level, Boolean upgraded) {
        return (BlockState)super.getState(level).m_61124_((Property)UPGRADED, (Comparable)upgraded);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!((Boolean)state.m_61143_((Property)UPGRADED)).booleanValue()) {
            return super.onSneakWrenched(state, context);
        }
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ElectricBurnerBlockEntity) {
            ElectricBurnerBlockEntity ebbe = (ElectricBurnerBlockEntity)entity;
            ebbe.setUpgrade(false);
            IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
            if (player != null && !player.m_7500_()) {
                ItemStack returned = ((Item)ItemRegistry.HEAT_UPGRADE.get()).m_7968_();
                player.m_150109_().m_150079_(returned);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElectricBurnerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ElectricBurnerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockRegistry.ELECTRIC_BURNER_ENTITY.get()), (level1, pos, state1, entity) -> entity.tick(level1, pos, state1));
    }
}

