/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import joptsimple.internal.Strings;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.dragonegg.moreburners.config.ClientConfig;
import net.dragonegg.moreburners.config.CommonConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBurnerBlockEntity
extends BlockEntity
implements IHaveGoggleInformation {
    public static final double SEETHING_HEAT = (Double)CommonConfig.SEETHING_HEAT.get();
    public static final double KINDLED_HEAT = (Double)CommonConfig.KINDLED_HEAT.get();
    public static final double FADING_HEAT = (Double)CommonConfig.FADING_HEAT.get();
    public static final double SMOULDERING_HEAT = (Double)CommonConfig.SMOULDERING_HEAT.get();
    public static final int BAR_LENGTH = (Integer)ClientConfig.HEAT_BAR_LENGTH.get();
    public double heat = 0.0;
    public double max_heat;
    protected int ticksExisted = 0;
    protected boolean canWork = true;
    protected int redstoneStrength = 0;

    public BaseBurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.heat = nbt.m_128459_("heat");
        this.max_heat = nbt.m_128459_("max_heat");
        this.redstoneStrength = nbt.m_128451_("redstone_strength");
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128347_("heat", this.heat);
        nbt.m_128347_("max_heat", this.max_heat);
        nbt.m_128405_("redstone_strength", this.redstoneStrength);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128347_("heat", this.heat);
        nbt.m_128347_("max_heat", this.max_heat);
        nbt.m_128405_("redstone_strength", this.redstoneStrength);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        this.updateRedstoneStrength(this.getPower(level, pos));
        if (this.redstoneStrength != 0) {
            this.max_heat *= (double)this.redstoneStrength / 16.0;
        }
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((BlockState)this.m_58900_());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState != heat) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
            this.m_6596_();
        }
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.NONE;
        if (this.heat >= SEETHING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.SEETHING;
        } else if (this.heat >= KINDLED_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.KINDLED;
        } else if (this.heat >= FADING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.FADING;
        } else if (this.heat >= SMOULDERING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return level;
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.redstoneStrength = signalStrength;
        this.m_6596_();
    }

    public int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ChatFormatting formatting = switch (this.getHeatLevel()) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> ChatFormatting.WHITE;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ChatFormatting.GOLD;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ChatFormatting.BLUE;
        };
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.status.title", new Object[]{Component.m_237115_((String)("moreburners.burner.status." + this.getHeatLevel().name().toLowerCase())).m_130940_(formatting)}), 0);
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").add(this.getHeatComponent(true)), 1);
        return true;
    }

    public void forGoggles(List<? super MutableComponent> tooltip, LangBuilder builder, int indents) {
        tooltip.add((MutableComponent)Lang.builder((String)"moreburners").text(Strings.repeat((char)' ', (int)BaseBurnerBlockEntity.getIndents(Minecraft.m_91087_().f_91062_, 4 + indents))).add(builder).component());
    }

    static int getIndents(Font font, int defaultIndents) {
        int spaceWidth = font.m_92895_(" ");
        if (4.0f == (float)spaceWidth) {
            return defaultIndents;
        }
        return Mth.m_14167_((float)(4.0f * (float)defaultIndents / (float)spaceWidth));
    }

    public MutableComponent getHeatComponent(boolean forGoggles) {
        int level = (int)(this.heat * (double)BAR_LENGTH / this.max_heat);
        return this.componentHelper(level, forGoggles);
    }

    private MutableComponent componentHelper(int level, boolean forGoggles) {
        MutableComponent base = Component.m_237119_().m_7220_((Component)this.bars(level, ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(BAR_LENGTH - level, ChatFormatting.DARK_RED));
        if (!forGoggles) {
            return base;
        }
        return Component.m_237115_((String)"moreburners.burner.status.heat").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"moreburners.burner.status.dots").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)base);
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.m_237113_((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }
}

