/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.json;

import cn.mcmod_mmf.mmlib.fluid.FluidHelper;
import cn.mcmod_mmf.mmlib.fluid.FluidIngredient;
import cn.mcmod_mmf.mmlib.recipe.ChanceResult;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractSerializer<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {

    public static class FluidIngredientSerializer
    extends AbstractSerializer<FluidIngredient> {
        private static final FluidIngredientSerializer INSTANCE = new FluidIngredientSerializer();

        private FluidIngredientSerializer() {
        }

        public JsonElement serialize(FluidIngredient src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize();
        }

        public FluidIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return FluidIngredient.deserialize(json);
        }

        public static FluidIngredientSerializer getInstance() {
            return INSTANCE;
        }
    }

    public static class FluidStackSerializer
    extends AbstractSerializer<FluidStack> {
        private static final FluidStackSerializer INSTANCE = new FluidStackSerializer();

        private FluidStackSerializer() {
        }

        public JsonElement serialize(FluidStack src, Type typeOfSrc, JsonSerializationContext context) {
            return FluidHelper.serializeFluidStack(src);
        }

        public FluidStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return FluidHelper.deserializeFluidStack(json.getAsJsonObject());
        }

        public static FluidStackSerializer getInstance() {
            return INSTANCE;
        }
    }

    public static class IngredientSerializer
    extends AbstractSerializer<Ingredient> {
        private static final IngredientSerializer INSTANCE = new IngredientSerializer();

        private IngredientSerializer() {
        }

        public JsonElement serialize(Ingredient src, Type typeOfSrc, JsonSerializationContext context) {
            return src.m_43942_();
        }

        public Ingredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Ingredient.m_43917_((JsonElement)json);
        }

        public static IngredientSerializer getInstance() {
            return INSTANCE;
        }
    }

    public static class ChanceResultSerializer
    extends AbstractSerializer<ChanceResult> {
        private static final ChanceResultSerializer INSTANCE = new ChanceResultSerializer();

        private ChanceResultSerializer() {
        }

        public JsonElement serialize(ChanceResult src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)src.stack().m_41720_()).toString());
            if (src.stack().m_41613_() > 1) {
                objectResult.addProperty("count", (Number)src.stack().m_41613_());
            }
            if (src.stack().m_41782_()) {
                objectResult.add("nbt", JsonParser.parseString((String)src.stack().m_41783_().toString()));
            }
            if (src.chance() != 1.0f) {
                objectResult.addProperty("chance", (Number)Float.valueOf(src.chance()));
            }
            return objectResult;
        }

        public ChanceResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            return new ChanceResult(CraftingHelper.getItemStack((JsonObject)jsonObj, (boolean)true), jsonObj.has("chance") ? GsonHelper.m_13915_((JsonObject)jsonObj.getAsJsonObject(), (String)"chance") : 1.0f);
        }

        public static ChanceResultSerializer getInstance() {
            return INSTANCE;
        }
    }

    public static class ItemStackSerializer
    extends AbstractSerializer<ItemStack> {
        private static final ItemStackSerializer INSTANCE = new ItemStackSerializer();

        private ItemStackSerializer() {
        }

        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)src.m_41720_()).toString());
            if (src.m_41613_() > 1) {
                objectResult.addProperty("count", (Number)src.m_41613_());
            }
            if (src.m_41782_()) {
                objectResult.add("nbt", JsonParser.parseString((String)src.m_41783_().toString()));
            }
            return objectResult;
        }

        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(), (boolean)true);
        }

        public static ItemStackSerializer getInstance() {
            return INSTANCE;
        }
    }
}

