/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.input;

import java.util.function.Consumer;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class DoubleClickController {
    private static final int MAX_TICKS = 10;
    private Integer lastKey;
    private int ticks = 10;
    private Consumer<InputEvent.Key> listener = e -> {};

    public DoubleClickController() {
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
        MinecraftForge.EVENT_BUS.addListener(this::onClick);
    }

    public void addListener(Consumer<InputEvent.Key> listener) {
        this.listener = listener;
    }

    private void onTick(TickEvent.ClientTickEvent event) {
        if (this.lastKey == null) {
            return;
        }
        --this.ticks;
        if (this.ticks <= 0) {
            this.lastKey = null;
        }
    }

    private void onClick(InputEvent.Key event) {
        if (event.getAction() != 1) {
            return;
        }
        if (this.lastKey == null || this.lastKey.intValue() != event.getKey()) {
            this.lastKey = event.getKey();
            this.ticks = 10;
        } else if (this.ticks > 0) {
            this.lastKey = null;
            this.listener.accept(event);
        }
    }
}

