/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.packet;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.chassis_core.client.network.ClientPlayHandler;
import com.nukateam.chassis_core.common.config.ChassisConfig;
import com.nukateam.chassis_core.common.network.managers.NetworkChassisManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class S2CMessageUpdateChassisConfig
extends PlayMessage<S2CMessageUpdateChassisConfig> {
    private ImmutableMap<ResourceLocation, ChassisConfig> registeredConfigs;

    public void encode(S2CMessageUpdateChassisConfig message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkChassisManager.get()));
        NetworkChassisManager.get().writeRegisteredConfig(buffer);
    }

    public S2CMessageUpdateChassisConfig decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateChassisConfig message = new S2CMessageUpdateChassisConfig();
        message.registeredConfigs = NetworkChassisManager.readRegisteredConfigs(buffer);
        return message;
    }

    public void handle(S2CMessageUpdateChassisConfig message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleUpdateChassis(message));
        supplier.setHandled(true);
    }

    public ImmutableMap<ResourceLocation, ChassisConfig> getRegisteredConfig() {
        return this.registeredConfigs;
    }
}

