/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.util.helpers;

import com.nukateam.chassis_core.common.util.helpers.MathHelper;

public class HeatController {
    protected int heat = 0;
    protected int heatCapacity = 0;

    public int getHeat() {
        return this.heat;
    }

    public void setHeat(int heat) {
        this.heat = heat;
    }

    public void addHeat(int value) {
        if (value <= 0) {
            return;
        }
        this.heat = this.heat + value <= this.getHeatCapacity() ? (this.heat += value) : this.getHeatCapacity();
    }

    public void subHeat(int value) {
        if (value <= 0 || this.heat == 0) {
            return;
        }
        this.heat = this.heat - value >= 0 ? (this.heat -= value) : 0;
    }

    public int getHeatCapacity() {
        return this.heatCapacity;
    }

    public int getHeatInPercent() {
        return MathHelper.getInPercents(this.heat, this.getHeatCapacity());
    }

    public void doHeatAction(int heat, Runnable action) {
        if (!this.canDoAction(heat)) {
            return;
        }
        action.run();
        this.addHeat(heat);
    }

    public boolean canDoAction(int heat) {
        return heat + this.heat <= this.getHeatCapacity();
    }
}

