/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.example.common.registery;

import com.nukateam.example.common.modifiers.MinigunModifier;
import com.nukateam.example.common.modifiers.TestModifier;
import com.nukateam.example.common.registery.Attachments;
import com.nukateam.example.common.registery.WeaponModifiers;
import com.nukateam.ntgl.common.data.attachment.impl.Barrel;
import com.nukateam.ntgl.common.data.attachment.impl.Grip;
import com.nukateam.ntgl.common.data.attachment.impl.Magazine;
import com.nukateam.ntgl.common.data.attachment.impl.Stock;
import com.nukateam.ntgl.common.foundation.item.AmmoBoxItem;
import com.nukateam.ntgl.common.foundation.item.AmmoItem;
import com.nukateam.ntgl.common.foundation.item.StunGrenadeItem;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.attachment.BarrelItem;
import com.nukateam.ntgl.common.foundation.item.attachment.GripItem;
import com.nukateam.ntgl.common.foundation.item.attachment.MagazineItem;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.foundation.item.attachment.StockItem;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ExampleWeapons {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ntgl");
    public static final RegistryObject<WeaponItem> PISTOL10MM = ExampleWeapons.registerGun("pistol10mm", new TestModifier());
    public static final RegistryObject<WeaponItem> PIPE_PISTOL = ExampleWeapons.registerGun("pipepistol", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> CLASSIC10MM = ExampleWeapons.registerGun("classic10mm", 10);
    public static final RegistryObject<WeaponItem> SCOUT10MM = ExampleWeapons.registerGun("scout10mm", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> PIPE_REVOLVER = ExampleWeapons.registerGun("piperevolver", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> FATMAN = ExampleWeapons.registerGun("fatman", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> MINIGUN = ExampleWeapons.registerGun("minigun", new MinigunModifier());
    public static final RegistryObject<WeaponItem> POWDERGUN = ExampleWeapons.registerGun("powdergun", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> SHOTGUN = ExampleWeapons.registerGun("shotgun", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> FLAMER = ExampleWeapons.registerGun("flamer", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> GATLING = ExampleWeapons.registerGun("gatling", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> REVOLVER = ExampleWeapons.registerGun("revolver", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> RPG = ExampleWeapons.registerGun("rpg", new IWeaponModifier[0]);
    public static final RegistryObject<WeaponItem> HAMMER = ExampleWeapons.registerGun("hammer", new IWeaponModifier[0]);
    public static final RegistryObject<Item> GRENADE = ITEMS.register("grenade", () -> new WeaponItem(new Item.Properties(), new IWeaponModifier[0]));
    public static final RegistryObject<Item> GRENADE_OG = ITEMS.register("grenade_old", () -> new WeaponItem(new Item.Properties(), new IWeaponModifier[0]));
    public static final RegistryObject<Item> STUN_GRENADE = ITEMS.register("stun_grenade", () -> new StunGrenadeItem(new Item.Properties()));
    public static final RegistryObject<Item> ROUND10MM = ITEMS.register("round10mm", () -> new AmmoItem(new Item.Properties().m_41503_(100), new IWeaponModifier[0]));
    public static final RegistryObject<Item> ROUND38 = ExampleWeapons.registerAmmo("round38");
    public static final RegistryObject<Item> STEELBALLS = ExampleWeapons.registerAmmo("steel_ball");
    public static final RegistryObject<Item> ROUND45 = ExampleWeapons.registerAmmo("round45");
    public static final RegistryObject<Item> ROUND5MM = ExampleWeapons.registerAmmo("round5mm");
    public static final RegistryObject<Item> ROUND44 = ExampleWeapons.registerAmmo("round44");
    public static final RegistryObject<Item> ROUND50 = ExampleWeapons.registerAmmo("round50");
    public static final RegistryObject<Item> ROUND380 = ExampleWeapons.registerAmmo("round380");
    public static final RegistryObject<Item> ROUND556 = ExampleWeapons.registerAmmo("round556");
    public static final RegistryObject<Item> SHOTSHELL = ExampleWeapons.registerAmmo("shotshell");
    public static final RegistryObject<Item> ROUND127 = ExampleWeapons.registerAmmo("round127");
    public static final RegistryObject<Item> ROUND22 = ExampleWeapons.registerAmmo("round22");
    public static final RegistryObject<Item> MININUKE = ExampleWeapons.registerAmmo("mini_nuke");
    public static final RegistryObject<Item> FUEL = ExampleWeapons.registerAmmo("fuel");
    public static final RegistryObject<Item> HOLOGRAPHIC_SIGHT = ITEMS.register("holographic_sight", () -> new ScopeItem(Attachments.LONG_SCOPE, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COLLIMATOR_SIGHT = ITEMS.register("collimator_sight", () -> new ScopeItem(Attachments.SHORT_SCOPE, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> SILENCER = ITEMS.register("silencer", () -> new BarrelItem(Barrel.create(8.0f, WeaponModifiers.SILENCED, WeaponModifiers.REDUCED_DAMAGE), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> LIGHT_STOCK = ITEMS.register("light_stock", () -> new StockItem(Stock.create(WeaponModifiers.BETTER_CONTROL), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> TACTICAL_STOCK = ITEMS.register("tactical_stock", () -> new StockItem(Stock.create(WeaponModifiers.STABILISED), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> WEIGHTED_STOCK = ITEMS.register("weighted_stock", () -> new StockItem(Stock.create(WeaponModifiers.SUPER_STABILISED), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> LIGHT_GRIP = ITEMS.register("light_grip", () -> new GripItem(Grip.create(WeaponModifiers.LIGHT_RECOIL), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> SPECIALISED_GRIP = ITEMS.register("specialised_grip", () -> new GripItem(Grip.create(WeaponModifiers.REDUCED_RECOIL), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> EXTENDED_MAGAZINE = ITEMS.register("extended_magazine", () -> new MagazineItem(Magazine.create(30, WeaponModifiers.SLOW_ADS), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> DRUM_MAGAZINE = ITEMS.register("drum_magazine", () -> new MagazineItem(Magazine.create(60, WeaponModifiers.SLOWER_ADS, WeaponModifiers.EXTENDED_MAG), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> HEAD_STONE = ITEMS.register("hammer_stone", () -> new GripItem(Grip.create(WeaponModifiers.REDUCED_RECOIL), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> HAMMER_DIAMOND = ITEMS.register("hammer_diamond", () -> new GripItem(Grip.create(WeaponModifiers.REDUCED_RECOIL), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> AMMO_BOX = ITEMS.register("ammo_box", () -> new AmmoBoxItem(new Item.Properties().m_41487_(1), 100));

    public static RegistryObject<WeaponItem> registerGun(String name, IWeaponModifier ... modifiers) {
        return ITEMS.register(name, () -> new WeaponItem(new Item.Properties().m_41487_(1), modifiers));
    }

    public static RegistryObject<WeaponItem> registerGun(String name, int durability) {
        return ITEMS.register(name, () -> new WeaponItem(new Item.Properties().m_41503_(durability), new IWeaponModifier[0]));
    }

    public static RegistryObject<Item> registerAmmo(String name) {
        return ITEMS.register(name, () -> new AmmoItem(new Item.Properties(), new IWeaponModifier[0]));
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

