/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.animators;

import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.audio.GunShotSound;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.client.handlers.ClientTickHandler;
import com.nukateam.ntgl.client.model.gun.GeoWeaponModel;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.client.util.handler.ClientEquipHandler;
import com.nukateam.ntgl.client.util.handler.ClientMeleeHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ClientShootingHandler;
import com.nukateam.ntgl.client.util.handler.ShootingData;
import com.nukateam.ntgl.client.util.helpers.TransformUtils;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.helpers.PlayerHelper;
import com.nukateam.ntgl.common.util.interfaces.IConfigProvider;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.AnimationHelper;
import com.nukateam.ntgl.common.util.util.Cycler;
import com.nukateam.ntgl.common.util.util.ThrowableStateHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

@OnlyIn(value=Dist.CLIENT)
public class WeaponAnimator
extends ItemAnimator
implements IConfigProvider<WeaponConfig> {
    public static final String STATIC = "static";
    public static final String PREPARE = "prepare";
    public static final String PREPARE_SAFE = "prepare_safe";
    public static final String THROW = "throw";
    public static final String THROW_SAFE = "throw_safe";
    public static final String VOID = "void";
    protected final DynamicWeaponRenderer<WeaponAnimator> renderer;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final ClientShootingHandler shootingHandler = ClientShootingHandler.get();
    protected final ClientReloadHandler reloadHandler = ClientReloadHandler.get();
    protected final AnimationHelper<WeaponAnimator> animationHelper;
    protected final AnimationController<WeaponAnimator> TRIGGER_CONTROLLER;
    protected final AnimationController<WeaponAnimator> MAIN_CONTROLLER;
    protected final AnimationController<WeaponAnimator> REVOLVER_CONTROLLER;
    protected final AnimationController<WeaponAnimator> BARREL_CONTROLLER;
    protected final AnimationController<WeaponAnimator> TICKING_CONTROLLER;
    protected final InteractionHand arm;
    protected Cycler barrelCycler = new Cycler(1, this.getBarrelAmount());
    protected Cycler chamberCycler = null;
    protected IWeapon currentGun = null;
    protected int rate;
    protected int equipTime;
    protected int meleeDelay;
    protected int meleeCooldown;
    protected int fireDelay;
    protected int reloadTime;
    protected int reloadStartTime;
    protected int reloadEndTime;
    protected boolean isEquiping;
    protected ItemStack itemCache = ItemStack.f_41583_;
    protected ThrowMode throwMode;
    protected int prepareTime;
    protected int throwingTime;

    public WeaponAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType);
        this.renderer = renderer;
        this.arm = this.getArm();
        ClientTickHandler.addTicker((Object)this, this::tick);
        this.TRIGGER_CONTROLLER = this.createController("triggerController", (AnimationController.AnimationStateHandler<WeaponAnimator>)((AnimationController.AnimationStateHandler)event -> PlayState.CONTINUE));
        this.MAIN_CONTROLLER = this.createController("mainController", this.animate()).setSoundKeyframeHandler(this::handleSoundEvent).triggerableAnim("equip", RawAnimation.begin().then("equip", Animation.LoopType.LOOP));
        this.REVOLVER_CONTROLLER = this.createController("revolverController", this.animateRevolver());
        this.BARREL_CONTROLLER = this.createController("barrelController", this.animateBarrels());
        this.TICKING_CONTROLLER = this.createController("tickingController", this.animateTick());
        this.animationHelper = new AnimationHelper<WeaponAnimator>(this, GeoWeaponModel.INSTANCE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.MAIN_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.TRIGGER_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.REVOLVER_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.BARREL_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.TICKING_CONTROLLER});
    }

    @Override
    public WeaponConfig getConfig() {
        IConfigProvider config;
        Object t;
        Item item = this.getStack().m_41720_();
        if (item instanceof IConfigProvider && (t = (config = (IConfigProvider)item).getConfig()) instanceof WeaponConfig) {
            WeaponConfig weaponConfig = (WeaponConfig)t;
            return weaponConfig;
        }
        return new WeaponConfig();
    }

    public void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    protected void tickStart() {
        Item item = this.getStack().m_41720_();
        if (!(item instanceof IWeapon)) {
            return;
        }
        IWeapon weapon = (IWeapon)item;
        WeaponData data = this.getGunData();
        if (this.getEntity().m_21120_(this.getArm()).m_41720_() instanceof IWeapon) {
            this.rate = WeaponModifierHelper.getRate(this.shootingHandler.getWeaponData(this.getEntity(), this.getArm()));
        }
        this.equipTime = WeaponModifierHelper.getEquipTime(data);
        this.isEquiping = EquipTracker.isEquiping(this.getEntity(), this.getArm());
        this.meleeDelay = WeaponModifierHelper.getMeleeDelay(data);
        this.meleeCooldown = WeaponModifierHelper.getMeleeCooldown(data);
        this.fireDelay = WeaponModifierHelper.getFireDelay(data);
        this.reloadTime = WeaponModifierHelper.getReloadTime(data);
        this.reloadStartTime = WeaponModifierHelper.getReloadStart(data);
        this.reloadEndTime = WeaponModifierHelper.getReloadEnd(data);
        WeaponConfig conging = weapon.getModifiedConfig(this.getStack());
        this.prepareTime = WeaponModifierHelper.getPrepareTime(data);
        this.throwingTime = WeaponModifierHelper.getThrowTime(data);
        this.throwMode = ThrowableStateHelper.getThrowMode(data);
        this.setupCycledAnimations();
    }

    protected void tickEnd() {
    }

    protected int getBarrelAmount() {
        return 1;
    }

    protected LivingEntity getEntity() {
        return this.renderer.getRenderEntity();
    }

    protected IWeapon getWeapon() {
        return (IWeapon)this.getStack().m_41720_();
    }

    @NotNull
    protected WeaponData getGunData() {
        return new WeaponData(this.getStack(), this.getEntity());
    }

    protected boolean isOneHanded(ItemStack stack) {
        return WeaponModifierHelper.isOneHanded(new WeaponData(stack, this.getEntity()));
    }

    @NotNull
    protected AnimationController<WeaponAnimator> createController(String name, AnimationController.AnimationStateHandler<WeaponAnimator> animate) {
        return new AnimationController((GeoAnimatable)this, name, 0, animate);
    }

    protected InteractionHand getArm() {
        return TransformUtils.isRightHand(this.transformType) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    protected AnimationController.AnimationStateHandler<WeaponAnimator> animate() {
        return event -> {
            if (this.itemCache != this.getStack()) {
                this.itemCache = this.getStack();
                return event.setAndContinue(this.playVoid());
            }
            try {
                AnimationController controller = event.getController();
                controller.setAnimationSpeed(1.0);
                LivingEntity shooter = this.getEntity();
                if (!TransformUtils.isHandTransform(this.transformType)) {
                    return event.setAndContinue(this.getHoldAnimation((AnimationState<WeaponAnimator>)event));
                }
                boolean isShooting = this.shootingHandler.isShooting(shooter, this.arm);
                ShootingData data = this.shootingHandler.getShootingData(this.arm);
                RawAnimation animation = RawAnimation.begin();
                if (ClientEquipHandler.get().isEquiping(this.arm)) {
                    animation = this.getEquipAnimation((AnimationState<WeaponAnimator>)event);
                } else if (this.isPreparing()) {
                    animation = this.getPrepareAnimation((AnimationState<WeaponAnimator>)event);
                } else if (this.isThrowing()) {
                    animation = this.getThrowingAnimation((AnimationState<WeaponAnimator>)event);
                } else if (ClientMeleeHandler.isOnDelay(shooter, this.arm)) {
                    animation = this.getMeleeDelayAnimation((AnimationState<WeaponAnimator>)event);
                } else if (ClientMeleeHandler.isOnCooldown(shooter, this.arm)) {
                    animation = this.getMeleeCooldownAnimation((AnimationState<WeaponAnimator>)event);
                } else if (this.fireDelay > 0 && data.fireTimer > 0 && this.fireDelay != data.fireTimer) {
                    animation = this.getChargingAnimation((AnimationState<WeaponAnimator>)event, data);
                } else if (this.reloadHandler.isReloading(shooter, this.arm)) {
                    animation = this.getReloadingAnimation((AnimationState<WeaponAnimator>)event);
                } else if (isShooting) {
                    animation = this.getShootingAnimation((AnimationState<WeaponAnimator>)event);
                } else if (this.reloadHandler.isReloading(shooter, PlayerHelper.getOpposite(this.arm))) {
                    animation = this.getHideAnimation((AnimationState<WeaponAnimator>)event);
                } else if (ClientHandler.getInspectionTicks(this.getArm()) > 0) {
                    animation = this.getInspectionAnimation((AnimationState<WeaponAnimator>)event);
                } else if (this.currentGun == this.getWeapon()) {
                    animation = this.getHoldAnimation((AnimationState<WeaponAnimator>)event);
                } else {
                    this.currentGun = this.getWeapon();
                    animation = this.playGunAnim("shot", Animation.LoopType.LOOP);
                }
                return animation != null ? event.setAndContinue(animation) : PlayState.STOP;
            }
            catch (Exception e) {
                Ntgl.LOGGER.error(e.getMessage());
                return PlayState.STOP;
            }
        };
    }

    @NotNull
    private RawAnimation playVoid() {
        if (this.animationHelper.hasAnimation(VOID)) {
            return RawAnimation.begin().then(VOID, Animation.LoopType.PLAY_ONCE);
        }
        return RawAnimation.begin();
    }

    protected AnimationController.AnimationStateHandler<WeaponAnimator> animateTick() {
        return event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation holdAnimation = this.getHoldAnimation((AnimationState<WeaponAnimator>)event);
            if (!TransformUtils.isHandTransform(this.transformType)) {
                return PlayState.STOP;
            }
            RawAnimation animation = RawAnimation.begin();
            if (this.throwMode != ThrowMode.UNSAFE || !this.isHolding() && !this.isThrowing()) {
                return PlayState.STOP;
            }
            animation = this.getTickingAnimation((AnimationState<WeaponAnimator>)event);
            return event.setAndContinue(animation);
        };
    }

    protected AnimationController.AnimationStateHandler<WeaponAnimator> animateRevolver() {
        return event -> this.getCycledAnimation((AnimationState<WeaponAnimator>)event, "chamber", this.chamberCycler);
    }

    protected AnimationController.AnimationStateHandler<WeaponAnimator> animateBarrels() {
        return event -> this.getCycledAnimation((AnimationState<WeaponAnimator>)event, "barrel", this.barrelCycler);
    }

    protected boolean isPreparing() {
        return (Boolean)ModSyncedDataKeys.getPreparingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected boolean isHolding() {
        return (Boolean)ModSyncedDataKeys.getHoldingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected boolean isThrowing() {
        return (Boolean)ModSyncedDataKeys.getThrowingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected PlayState getCycledAnimation(AnimationState<WeaponAnimator> event, String animationName, Cycler cycler) {
        event.getController().setAnimationSpeed(1.0);
        if (TransformUtils.isHandTransform(this.transformType) && cycler != null) {
            LivingEntity entity = this.getEntity();
            boolean isShooting = this.shootingHandler.isShooting(entity, TransformUtils.getHand(this.transformType));
            String finalAnim = animationName + cycler.getCurrent();
            RawAnimation animation = null;
            if (isShooting && this.animationHelper.hasAnimation(finalAnim)) {
                animation = RawAnimation.begin().then(finalAnim, Animation.LoopType.HOLD_ON_LAST_FRAME);
                this.animationHelper.syncAnimation(event, finalAnim, this.rate);
            }
            return event.setAndContinue(animation);
        }
        return PlayState.STOP;
    }

    protected RawAnimation getHoldAnimation(AnimationState<WeaponAnimator> event) {
        return this.playGunAnim("hold", Animation.LoopType.LOOP);
    }

    protected RawAnimation getStaticAnimation(AnimationState<WeaponAnimator> event) {
        return this.playGunAnim(STATIC, Animation.LoopType.LOOP);
    }

    protected RawAnimation getHideAnimation(AnimationState<WeaponAnimator> event) {
        return RawAnimation.begin().then("hide", Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    protected RawAnimation getInspectionAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("inspect", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "inspect", ClientHandler.getMaxInspectionTicks());
        return animation;
    }

    protected RawAnimation getChargingAnimation(AnimationState<WeaponAnimator> event, ShootingData shootingData) {
        RawAnimation animation = RawAnimation.begin();
        if (this.animationHelper.hasAnimation("charge")) {
            this.BARREL_CONTROLLER.stop();
            this.BARREL_CONTROLLER.setAnimation(this.playVoid());
            animation = this.playGunAnim("charge", Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, "charge", this.fireDelay);
        }
        return animation;
    }

    protected RawAnimation getTickingAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("ticking", Animation.LoopType.LOOP);
        return animation;
    }

    protected RawAnimation getMeleeDelayAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("melee", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "melee", this.meleeDelay);
        return animation;
    }

    protected RawAnimation getMeleeCooldownAnimation(AnimationState<WeaponAnimator> event) {
        if (!this.animationHelper.hasAnimation("melee_end")) {
            return this.getHoldAnimation(event);
        }
        RawAnimation animation = this.playGunAnim("melee_end", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "melee_end", this.meleeCooldown);
        return animation;
    }

    protected RawAnimation getEquipAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("equip", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "equip", this.equipTime);
        return animation;
    }

    protected RawAnimation getShootingAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("shot", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "shot", this.rate);
        return animation;
    }

    protected RawAnimation getReloadingAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = RawAnimation.begin();
        animation = (Boolean)ModSyncedDataKeys.RELOAD_START.getValue((Entity)this.getEntity()) != false ? this.getStartReloadAnimation(event) : ((Boolean)ModSyncedDataKeys.RELOAD_END.getValue((Entity)this.getEntity()) != false ? this.getEndReloadAnimation(event) : this.getDefaultReloadAnimation(event));
        return animation;
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "reload", this.reloadTime);
        return animation;
    }

    protected RawAnimation getEndReloadAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload_end", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "reload_end", this.reloadEndTime);
        return animation;
    }

    protected RawAnimation getStartReloadAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload_start", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "reload_start", this.reloadStartTime);
        return animation;
    }

    protected RawAnimation getPrepareAnimation(AnimationState<WeaponAnimator> event) {
        String name = PREPARE;
        if (this.throwMode == ThrowMode.SAFE && this.animationHelper.hasAnimation(PREPARE_SAFE)) {
            name = PREPARE_SAFE;
        }
        RawAnimation animation = this.playGunAnim(name, Animation.LoopType.HOLD_ON_LAST_FRAME);
        this.animationHelper.syncAnimation(event, this.prepareTime, name);
        return animation;
    }

    protected RawAnimation getThrowingAnimation(AnimationState<WeaponAnimator> event) {
        String name = THROW;
        if (this.throwMode == ThrowMode.SAFE && this.animationHelper.hasAnimation(THROW_SAFE)) {
            name = THROW_SAFE;
        }
        RawAnimation animation = this.playGunAnim(name, Animation.LoopType.HOLD_ON_LAST_FRAME);
        this.animationHelper.syncAnimation(event, this.throwingTime, name);
        return animation;
    }

    protected void handleSoundEvent(SoundKeyframeEvent<WeaponAnimator> event) {
        LocalPlayer player = this.minecraft.f_91074_;
        String name = event.getKeyframeData().getSound();
        HashMap<String, ResourceLocation> sounds = ((WeaponConfig)this.getWeapon().getConfig()).getSoundsMap();
        ResourceLocation sound = sounds.get(name);
        if (sound != null && player != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)new GunShotSound(sound, SoundSource.PLAYERS, player.m_20182_(), 1.0f, 1.0f, true));
        }
    }

    protected RawAnimation playGunAnim(String name, Animation.LoopType loopType) {
        if (TransformUtils.isFirstPerson(this.getTransformType())) {
            String gunAnim = this.getGunAnim(name);
            return RawAnimation.begin().then(gunAnim, loopType);
        }
        String tpvOneHand = name + "_one_hand_tpv";
        String tpv = name + "_tpv";
        if (this.isOneHanded() && this.animationHelper.hasAnimation(tpvOneHand)) {
            return RawAnimation.begin().then(tpvOneHand, loopType);
        }
        if (this.animationHelper.hasAnimation(tpv)) {
            return RawAnimation.begin().then(tpv, loopType);
        }
        return RawAnimation.begin();
    }

    protected String getGunAnim(String name) {
        boolean isOneHanded = this.isOneHanded();
        if (isOneHanded && this.animationHelper.hasAnimation((String)name + "_one_hand")) {
            name = (String)name + "_one_hand";
        }
        return name;
    }

    private boolean isOneHanded() {
        LivingEntity entity = this.getEntity();
        ItemStack currentItem = entity.m_21120_(this.arm);
        ItemStack oppositeItem = entity.m_21120_(PlayerHelper.getOpposite(this.arm));
        boolean isOneHanded = this.isOneHanded(currentItem) && this.isOneHanded(oppositeItem) && !oppositeItem.m_41619_() || this.arm == InteractionHand.OFF_HAND;
        boolean hasShield = this.isOneHanded(currentItem) && oppositeItem.m_41720_() instanceof ShieldItem;
        boolean isS = hasShield || isOneHanded;
        return isS;
    }

    private void setupCycledAnimations() {
        LivingEntity entity = this.getEntity();
        int cooldown = this.shootingHandler.getCooldown(entity, this.arm);
        WeaponData data = this.getGunData();
        int maxAmmo = WeaponModifierHelper.getMaxAmmo(data);
        if (this.chamberCycler == null || this.chamberCycler.getMax() != maxAmmo) {
            this.chamberCycler = new Cycler(1, maxAmmo);
        }
        if (cooldown == this.rate) {
            this.barrelCycler.cycle();
            this.chamberCycler.cycle();
        }
    }
}

