/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.example.common.registery.ExampleWeapons;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.render.screen.CheckBox;
import com.nukateam.ntgl.client.util.helpers.render.ModelRenderUtil;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.foundation.blockentity.WorkbenchBlockEntity;
import com.nukateam.ntgl.common.foundation.container.WorkbenchContainer;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipe;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipes;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageCraft;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.modules.datapack.managers.NetworkWeaponManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchContainer> {
    private static final ResourceLocation GUI_BASE = new ResourceLocation("ntgl", "textures/gui/workbench.png");
    private static boolean showRemaining = false;
    private Tab currentTab;
    private List<Tab> tabs = new ArrayList<Tab>();
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private Inventory playerInventory;
    private WorkbenchBlockEntity workbench;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private ItemStack displayStack = ItemStack.f_41583_;

    public WorkbenchScreen(WorkbenchContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workbench = container.getWorkbench();
        this.f_97726_ = 275;
        this.f_97727_ = 184;
        this.materials = new ArrayList<MaterialItem>();
        this.createTabs(WorkbenchRecipes.getAll(playerInventory.f_35978_.m_9236_()));
        if (!this.tabs.isEmpty()) {
            this.f_97727_ += 28;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.tabs.isEmpty()) {
            this.f_97736_ += 28;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index - 1 < 0) {
                this.loadItem(this.currentTab.getRecipes().size() - 1);
            } else {
                this.loadItem(index - 1);
            }
        }).m_252794_(this.f_97735_ + 9, this.f_97736_ + 18).m_253046_(15, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index + 1 >= this.currentTab.getRecipes().size()) {
                this.loadItem(0);
            } else {
                this.loadItem(index + 1);
            }
        }).m_252794_(this.f_97735_ + 153, this.f_97736_ + 18).m_253046_(15, 20).m_253136_());
        this.btnCraft = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.ntgl.workbench.assemble"), button -> {
            int index = this.currentTab.getCurrentIndex();
            WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
            ResourceLocation registryName = recipe.m_6423_();
            PacketHandler.getPlayChannel().sendToServer(new C2SMessageCraft(registryName, this.workbench.m_58899_()));
        }).m_252794_(this.f_97735_ + 195, this.f_97736_ + 16).m_253046_(74, 20).m_253136_());
        this.btnCraft.f_93623_ = false;
        this.checkBoxMaterials = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.f_97735_ + 172, this.f_97736_ + 51, (Component)Component.m_237115_((String)"gui.ntgl.workbench.show_remaining")));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadItem(this.currentTab.getCurrentIndex());
    }

    public void m_181908_() {
        super.m_181908_();
        for (MaterialItem material : this.materials) {
            material.tick();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        this.btnCraft.f_93623_ = canCraft;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.m_6375_(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!ModelRenderUtil.isMouseWithin((int)mouseX, (int)mouseY, this.f_97735_ + 28 * i, this.f_97736_ - 28, 28, 28)) continue;
            this.currentTab = this.tabs.get(i);
            this.loadItem(this.currentTab.getCurrentIndex());
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return result;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int offset = this.tabs.isEmpty() ? 0 : 28;
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ - 28 + offset, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.playerInventory.m_5446_(), this.f_97730_, this.f_97731_ - 9 + offset, 0x404040, false);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        for (i = 0; i < this.tabs.size(); ++i) {
            if (!ModelRenderUtil.isMouseWithin(mouseX, mouseY, startX + 28 * i, startY - 28, 28, 28)) continue;
            this.m_257404_((Component)Component.m_237115_((String)this.tabs.get(i).getTabKey()));
            this.m_280072_(graphics, mouseX, mouseY);
            return;
        }
        if (this.filteredMaterials == null) {
            return;
        }
        for (i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 172;
            int itemY = startY + i * 19 + 63;
            if (!ModelRenderUtil.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)) == MaterialItem.EMPTY) continue;
            graphics.m_280153_(this.f_96547_, materialItem.getDisplayStack(), mouseX, mouseY);
            return;
        }
        if (ModelRenderUtil.isMouseWithin(mouseX, mouseY, startX + 8, startY + 38, 160, 48)) {
            graphics.m_280153_(this.f_96547_, this.displayStack, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        try {
            partialTicks = Minecraft.m_91087_().m_91296_();
            int startX = this.f_97735_;
            int startY = this.f_97736_;
            RenderSystem.enableBlend();
            this.drawUnselectedTabs(graphics, startX, startY);
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280218_(GUI_BASE, startX, startY, 0, 0, 173, 184);
            graphics.m_280411_(GUI_BASE, startX + 173, startY, 78, 184, 173.0f, 0.0f, 1, 184, 256, 256);
            graphics.m_280218_(GUI_BASE, startX + 251, startY, 174, 0, 24, 184);
            graphics.m_280218_(GUI_BASE, startX + 172, startY + 16, 198, 0, 20, 20);
            this.drawSelectedTab(graphics, startX, startY);
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.workbench.m_8020_(0).m_41619_()) {
                graphics.m_280218_(GUI_BASE, startX + 174, startY + 18, 165, 199, 16, 16);
            }
            ItemStack currentItem = this.displayStack;
            StringBuilder builder = new StringBuilder(currentItem.m_41786_().getString());
            if (currentItem.m_41613_() > 1) {
                builder.append(ChatFormatting.GOLD);
                builder.append(ChatFormatting.BOLD);
                builder.append(" x ");
                builder.append(currentItem.m_41613_());
            }
            graphics.m_280137_(this.f_96547_, builder.toString(), startX + 88, startY + 22, Color.WHITE.getRGB());
            WorkbenchScreen.renderGun(graphics, partialTicks, startX, startY, currentItem);
            this.filteredMaterials = this.getMaterials();
            for (int i = 0; i < this.filteredMaterials.size(); ++i) {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                MaterialItem materialItem = this.filteredMaterials.get(i);
                ItemStack stack = materialItem.getDisplayStack();
                if (stack.m_41619_()) continue;
                Lighting.m_84930_();
                if (materialItem.isEnabled()) {
                    graphics.m_280218_(GUI_BASE, startX + 172, startY + i * 19 + 63, 0, 184, 80, 19);
                } else {
                    graphics.m_280218_(GUI_BASE, startX + 172, startY + i * 19 + 63, 0, 222, 80, 19);
                }
                Object name = stack.m_41786_().getString();
                if (this.f_96547_.m_92895_((String)name) > 55) {
                    name = this.f_96547_.m_92834_((String)name, 50).trim() + "...";
                }
                graphics.m_280488_(this.f_96547_, (String)name, startX + 172 + 22, startY + i * 19 + 6 + 63, Color.WHITE.getRGB());
                graphics.m_280480_(stack, startX + 172 + 2, startY + i * 19 + 1 + 63);
                if (this.checkBoxMaterials.isToggled()) {
                    int count = InventoryUtil.getItemStackAmount((Player)Minecraft.m_91087_().f_91074_, stack);
                    stack = stack.m_41777_();
                    stack.m_41764_(stack.m_41613_() - count);
                }
                graphics.m_280370_(this.f_96547_, stack, startX + 172 + 2, startY + i * 19 + 1 + 63);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void renderGun(GuiGraphics graphics, float partialTicks, int startX, int startY, ItemStack currentItem) {
        Minecraft minecraft = Minecraft.m_91087_();
        GL11.glEnable((int)3089);
        ModelRenderUtil.scissor(startX + 8, startY + 17, 160, 70);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(startX + 88), (float)(startY + 60), 100.0f);
        poseStack.m_85841_(50.0f, -50.0f, 50.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_115143_(currentItem, ItemDisplayContext.FIXED, false, graphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, ModelRenderUtil.getModel(currentItem));
        buffer.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        GL11.glDisable((int)3089);
    }

    public List<Tab> getTabs() {
        return ImmutableList.copyOf(this.tabs);
    }

    private void drawSelectedTab(GuiGraphics graphics, int startX, int startY) {
        if (this.currentTab != null) {
            int i = this.tabs.indexOf(this.currentTab);
            int u = i == 0 ? 80 : 108;
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280218_(GUI_BASE, startX + 28 * i, startY - 28, u, 214, 28, 32);
            graphics.m_280480_(this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
        }
    }

    private void drawUnselectedTabs(GuiGraphics graphics, int startX, int startY) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == this.currentTab) continue;
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280218_(GUI_BASE, startX + 28 * i, startY - 28, 80, 184, 28, 32);
            graphics.m_280480_(tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.m_122780_((int)6, (Object)MaterialItem.EMPTY);
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : materialItem != MaterialItem.EMPTY).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, (MaterialItem)filteredMaterials.get(i));
        }
        return materials;
    }

    private void loadItem(int index) {
        WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
        this.displayStack = recipe.getItem().m_41777_();
        this.materials.clear();
        ImmutableList<WorkbenchIngredient> ingredients = recipe.getMaterials();
        if (ingredients != null) {
            for (WorkbenchIngredient ingredient : ingredients) {
                MaterialItem item = new MaterialItem(ingredient);
                item.updateEnabledState();
                this.materials.add(item);
            }
            this.currentTab.setCurrentIndex(index);
        }
    }

    private void createTabs(NonNullList<WorkbenchRecipe> recipes) {
        ArrayList weapons = new ArrayList();
        ArrayList<WorkbenchRecipe> attachments = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> ammo = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> misc = new ArrayList<WorkbenchRecipe>();
        for (Object recipe : recipes) {
            ItemStack output = ((WorkbenchRecipe)recipe).getItem();
            if (output == null) continue;
            if (output.m_41720_() instanceof IWeapon) {
                weapons.add(recipe);
                continue;
            }
            if (output.m_41720_() instanceof IAttachment) {
                attachments.add((WorkbenchRecipe)recipe);
                continue;
            }
            if (this.isAmmo(output)) {
                ammo.add((WorkbenchRecipe)recipe);
                continue;
            }
            misc.add((WorkbenchRecipe)recipe);
        }
        if (!weapons.isEmpty()) {
            HashMap<String, List> categoryRecipes = new HashMap<String, List>();
            for (WorkbenchRecipe recipe : weapons) {
                ItemStack weaponStack = recipe.getItem();
                IWeapon gunItem = (IWeapon)weaponStack.m_41720_();
                String category = gunItem.getModifiedConfig(weaponStack).getGeneral().getCategory();
                List buff = categoryRecipes.getOrDefault(category, new ArrayList());
                buff.add(recipe);
                categoryRecipes.put(category, buff);
            }
            for (Map.Entry entry : categoryRecipes.entrySet()) {
                List recipeList = (List)entry.getValue();
                String category = (String)entry.getKey();
                if (recipeList.isEmpty()) continue;
                Item item = ((WorkbenchRecipe)recipeList.get(0)).getItem().m_41720_();
                ItemStack icon = new ItemStack((ItemLike)item);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                WeaponData gunData = new WeaponData(icon, (LivingEntity)player);
                icon.m_41784_().m_128405_("AmmoCount", WeaponModifierHelper.getMaxAmmo(gunData));
                this.tabs.add(new Tab(icon, category, recipeList));
            }
        }
        if (!attachments.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ExampleWeapons.GRENADE.get()), "attachments", attachments));
        }
        if (!ammo.isEmpty()) {
            Item item = ((WorkbenchRecipe)ammo.get(0)).getItem().m_41720_();
            ItemStack icon = new ItemStack((ItemLike)item);
            this.tabs.add(new Tab(icon, "projectile", ammo));
        }
        if (!misc.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)Items.f_42127_), "misc", misc));
        }
        if (!this.tabs.isEmpty()) {
            this.currentTab = this.tabs.get(0);
        }
    }

    private boolean isAmmo(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof IAmmo) {
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        WeaponData gunData = new WeaponData(stack, (LivingEntity)player);
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        Objects.requireNonNull(id);
        for (IWeapon gunItem : NetworkWeaponManager.getClientRegisteredWeapons()) {
            Set<AmmoHolder> ammo = ((WeaponConfig)gunItem.getConfig()).getGeneral().getAmmo();
            for (AmmoHolder a : ammo) {
                if (!a.getId().equals((Object)id)) continue;
                return true;
            }
        }
        return false;
    }

    private static class Tab {
        private final ItemStack icon;
        private final String id;
        private final List<WorkbenchRecipe> items;
        private int currentIndex;

        public Tab(ItemStack icon, String id, List<WorkbenchRecipe> items) {
            this.icon = icon;
            this.id = id;
            this.items = items;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getTabKey() {
            return "gui.ntgl.workbench.tab." + this.id;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public List<WorkbenchRecipe> getRecipes() {
            return this.items;
        }
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private long lastTime = System.currentTimeMillis();
        private int displayIndex;
        private boolean enabled = false;
        private WorkbenchIngredient ingredient;
        private final List<ItemStack> displayStacks = new ArrayList<ItemStack>();

        private MaterialItem() {
        }

        private MaterialItem(WorkbenchIngredient ingredient) {
            this.ingredient = ingredient;
            Stream.of(ingredient.m_43908_()).forEach(stack -> {
                ItemStack displayStack = stack.m_41777_();
                displayStack.m_41764_(ingredient.getCount());
                this.displayStacks.add(displayStack);
            });
        }

        public WorkbenchIngredient getIngredient() {
            return this.ingredient;
        }

        public void tick() {
            if (this.ingredient == null) {
                return;
            }
            this.updateEnabledState();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime >= 1000L) {
                this.displayIndex = (this.displayIndex + 1) % this.displayStacks.size();
                this.lastTime = currentTime;
            }
        }

        public ItemStack getDisplayStack() {
            return this.ingredient != null ? this.displayStacks.get(this.displayIndex) : ItemStack.f_41583_;
        }

        public void updateEnabledState() {
            this.enabled = InventoryUtil.hasWorkstationIngredient((Player)Minecraft.m_91087_().f_91074_, this.ingredient);
        }

        public boolean isEnabled() {
            return this.ingredient == null || this.enabled;
        }
    }
}

