/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.ibm.icu.impl.Pair;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.RecoilHandler;
import com.nukateam.ntgl.client.util.handler.ShootingData;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessagePreFireSound;
import com.nukateam.ntgl.common.network.message.C2SMessageShoot;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerReviveHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientShootingHandler {
    private static ClientShootingHandler instance;
    public static float shootMsGap;
    private final HashMap<Pair<InteractionHand, LivingEntity>, Pair<WeaponData, Integer>> entityShootGaps = new HashMap();
    private final Map<InteractionHand, ShootingData> shootingData = Map.of(InteractionHand.MAIN_HAND, new ShootingData(0, null), InteractionHand.OFF_HAND, new ShootingData(0, null));

    private ClientShootingHandler() {
    }

    public static ClientShootingHandler get() {
        if (instance == null) {
            instance = new ClientShootingHandler();
        }
        return instance;
    }

    public static boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.MouseButton event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean isRightHand = event.getButton() == mc.f_91066_.f_92096_.getKey().m_84873_();
        boolean isLeftHand = event.getButton() == mc.f_91066_.f_92095_.getKey().m_84873_();
        ItemStack itemStack = heldItem = isRightHand ? player.m_21205_() : player.m_21206_();
        if (heldItem.m_41720_() instanceof IWeapon) {
            WeaponData data = new WeaponData(heldItem, (LivingEntity)player).setWeaponMode(WeaponMode.PRIMARY);
            if (event.getAction() == 1) {
                if (isRightHand) {
                    this.setupShootingData(data, InteractionHand.MAIN_HAND);
                }
                if (isLeftHand) {
                    this.setupShootingData(data, InteractionHand.OFF_HAND);
                }
            } else if (event.getAction() == 0) {
                if (isRightHand) {
                    this.resetShootingData(data, InteractionHand.MAIN_HAND);
                }
                if (isLeftHand) {
                    this.resetShootingData(data, InteractionHand.OFF_HAND);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof IWeapon) {
                this.cancelSwing(event);
            }
        } else if (event.isUseItem()) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offhandItem = player.m_21206_();
            if (offhandItem.m_41720_() instanceof IWeapon && WeaponModifierHelper.canUseOffhandWeapon((LivingEntity)player)) {
                this.cancelSwing(event);
                return;
            }
            if (mainHandItem.m_41720_() instanceof IWeapon) {
                if (event.getHand() == InteractionHand.OFF_HAND) {
                    if (offhandItem.m_41720_() == Items.f_42740_ && WeaponModifierHelper.getGripType(new WeaponData(mainHandItem, (LivingEntity)player)).isOneHanded()) {
                        return;
                    }
                    this.cancelSwing(event);
                    return;
                }
                if (AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                    this.cancelSwing(event);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderTickLow(TickEvent.RenderTickEvent evt) {
        if (!evt.type.equals((Object)TickEvent.Type.RENDER) || evt.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (shootMsGap > 0.0f) {
            shootMsGap -= evt.renderTickTime * ClientShootingHandler.visualCooldownMultiplier();
        } else if (shootMsGap < -0.05f) {
            shootMsGap = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelSwing(InputEvent.InteractionKeyMappingTriggered event) {
        event.setSwingHand(false);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            this.reduceGaps();
            if (!ClientShootingHandler.isInGame()) {
                return;
            }
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        }
    }

    public ShootingData getShootingData(InteractionHand arm) {
        return this.shootingData.get(arm);
    }

    public boolean isOnCooldown(LivingEntity entity, InteractionHand arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    public float getCooldownPercent(LivingEntity entity, InteractionHand hand) {
        ItemStack heldItem = entity.m_21120_(hand);
        if (heldItem.m_41720_() instanceof IWeapon) {
            WeaponData data = new WeaponData(heldItem, entity);
            int rate = WeaponModifierHelper.getRate(data);
            int cooldown = this.getCooldown(entity, hand);
            return (float)cooldown / (float)rate;
        }
        return 0.0f;
    }

    public int getCooldown(LivingEntity entity, InteractionHand arm) {
        Pair<WeaponData, Integer> key = this.entityShootGaps.get(Pair.of((Object)arm, (Object)entity));
        if (key != null) {
            return (Integer)key.second;
        }
        return 0;
    }

    @Nullable
    public WeaponData getWeaponData(LivingEntity entity, InteractionHand arm) {
        Pair<WeaponData, Integer> key = this.entityShootGaps.get(Pair.of((Object)arm, (Object)entity));
        if (key != null) {
            return (WeaponData)key.first;
        }
        return new WeaponData(entity.m_21120_(arm), entity);
    }

    public boolean isShooting(LivingEntity entity, InteractionHand arm) {
        return this.getCooldown(entity, arm) > 0;
    }

    public static float calcShootTickGap(int rpm) {
        float shootTickGap = 60.0f / (float)rpm * 20.0f;
        return shootTickGap;
    }

    public void fire(WeaponData gunData) {
        LivingEntity shooter = gunData.wielder;
        ItemStack heldItem = gunData.weapon;
        if (heldItem.m_41720_() instanceof IWeapon && WeaponStateHelper.hasAmmo(heldItem) && ClientShootingHandler.isGunMode(gunData) && !shooter.m_5833_()) {
            boolean isMainHand = shooter.m_21205_() == heldItem;
            InteractionHand hand = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            int shootGap = this.getCooldown(shooter, hand);
            if (shootGap <= 0) {
                if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(shooter, heldItem, hand))) {
                    return;
                }
                int rpm = WeaponModifierHelper.getRate(gunData);
                this.entityShootGaps.put((Pair<InteractionHand, LivingEntity>)Pair.of((Object)hand, (Object)shooter), (Pair<WeaponData, Integer>)Pair.of((Object)gunData, (Object)(shootGap += rpm)));
                shootMsGap = ClientShootingHandler.calcShootTickGap(rpm);
                RecoilHandler.get().lastRandPitch = RecoilHandler.get().lastRandPitch;
                RecoilHandler.get().lastRandYaw = RecoilHandler.get().lastRandYaw;
                try {
                    PacketHandler.getPlayChannel().sendToServer(new C2SMessageShoot(shooter.m_19879_(), shooter.m_5675_(1.0f), shooter.m_5686_(1.0f), RecoilHandler.get().lastRandPitch, RecoilHandler.get().lastRandYaw, hand, gunData.weaponMode));
                }
                catch (NullPointerException e) {
                    Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
                }
                MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(shooter, heldItem, hand));
            }
        } else {
            return;
        }
    }

    private static boolean isKeyAttackDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    private static boolean isUseKeyDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private void reduceGaps() {
        this.entityShootGaps.forEach((key, pair) -> {
            Integer val = (Integer)pair.second;
            if (val > 0) {
                Integer n = val;
                val = val - 1;
            }
            this.entityShootGaps.put((Pair<InteractionHand, LivingEntity>)key, (Pair<WeaponData, Integer>)Pair.of((Object)((WeaponData)pair.first), (Object)val));
        });
    }

    private void setupShootingData(WeaponData weaponData, InteractionHand arm) {
        assert (weaponData.weapon != null);
        if (!WeaponStateHelper.hasAmmo(weaponData.weapon)) {
            return;
        }
        ShootingData data = this.shootingData.get(arm);
        data.fireTimer = WeaponModifierHelper.getFireDelay(weaponData);
        data.gun = (IWeapon)weaponData.weapon.m_41720_();
    }

    private void resetShootingData(WeaponData weaponData, InteractionHand arm) {
        ShootingData data = this.shootingData.get(arm);
        if (data.fireTimer != 0 && !WeaponModifierHelper.needsFullCharge(weaponData)) {
            this.fire(weaponData);
        }
        data.fireTimer = 0;
        data.gun = null;
    }

    private static boolean isGunMode(WeaponData weaponData) {
        return WeaponModifierHelper.getWeaponAction(weaponData) == WeaponAction.SHOT;
    }

    public void handleInput(WeaponData weaponData, InteractionHand arm, KeyMapping key) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ShootingData data = this.shootingData.get(arm);
        FireMode fireMode = WeaponStateHelper.getFireMode(weaponData);
        int maxChargeTime = WeaponModifierHelper.getFireDelay(weaponData);
        if (!ClientShootingHandler.isGunMode(weaponData)) {
            return;
        }
        if (maxChargeTime != 0) {
            boolean isOnCooldown = ClientShootingHandler.get().isOnCooldown((LivingEntity)player, arm);
            if (data.fireTimer > 0 && !isOnCooldown) {
                if (data.fireTimer == maxChargeTime - 2) {
                    PacketHandler.getPlayChannel().sendToServer(new C2SMessagePreFireSound((Player)player));
                }
                --data.fireTimer;
            } else {
                this.fire(weaponData);
                if (data.fireTimer == 0 && !WeaponModifierHelper.isOneTimeCharge(weaponData)) {
                    this.setupShootingData(weaponData, arm);
                }
                if (maxChargeTime > 0 && fireMode != FireMode.AUTO) {
                    key.m_7249_(false);
                }
            }
        } else {
            this.fire(weaponData);
            if (fireMode != FireMode.AUTO) {
                key.m_7249_(false);
            }
        }
    }

    private static float visualCooldownMultiplier() {
        int fps = Minecraft.m_91087_().m_260875_();
        if (fps < 11) {
            return 8.0f;
        }
        if (fps < 21) {
            return 6.25f;
        }
        if (fps < 31) {
            return 1.25f;
        }
        if (fps < 61) {
            return 0.95f;
        }
        if (fps < 121) {
            return 0.625f;
        }
        if (fps < 181) {
            return 0.425f;
        }
        if (fps < 201) {
            return 0.35f;
        }
        return 0.25f;
    }

    static {
        shootMsGap = 0.0f;
    }
}

