/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.holders.MeleeMode;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Melee
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String DAMAGE = "damage";
    public static final String MODE = "mode";
    public static final String COOLDOWN = "cooldown";
    public static final String DELAY = "delay";
    public static final String DISTANCE = "distance";
    public static final String ATTACK_RADIUS = "attackRadius";
    public static final String KNOCKBACK = "knockback";
    public static final String MAX_TARGETS = "maxTargets";
    private MeleeMode mode = MeleeMode.SINGLE;
    private float damage = 1.0f;
    private int cooldown = 0;
    private int delay = 0;
    private float distance = 1.0f;
    private float knockback = 0.0f;
    private int maxTargets = 0;
    private float angle = 10.0f;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_(DAMAGE, this.damage);
        tag.m_128359_(MODE, this.mode.toString());
        tag.m_128405_(COOLDOWN, this.cooldown);
        tag.m_128405_(DELAY, this.delay);
        tag.m_128350_(DISTANCE, this.distance);
        tag.m_128350_(ATTACK_RADIUS, this.angle);
        tag.m_128350_(KNOCKBACK, this.knockback);
        tag.m_128405_(MAX_TARGETS, this.maxTargets);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(MODE, 8)) {
            this.mode = MeleeMode.getType(tag.m_128461_(MODE));
        }
        if (tag.m_128425_(DAMAGE, 99)) {
            this.damage = tag.m_128457_(DAMAGE);
        }
        if (tag.m_128425_(COOLDOWN, 99)) {
            this.cooldown = tag.m_128451_(COOLDOWN);
        }
        if (tag.m_128425_(DELAY, 99)) {
            this.delay = tag.m_128451_(DELAY);
        }
        if (tag.m_128425_(DISTANCE, 99)) {
            this.distance = tag.m_128457_(DISTANCE);
        }
        if (tag.m_128425_(ATTACK_RADIUS, 99)) {
            this.angle = tag.m_128457_(ATTACK_RADIUS);
        }
        if (tag.m_128425_(KNOCKBACK, 99)) {
            this.knockback = tag.m_128457_(KNOCKBACK);
        }
        if (tag.m_128425_(MAX_TARGETS, 99)) {
            this.maxTargets = tag.m_128451_(MAX_TARGETS);
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
        JsonObject object = new JsonObject();
        object.addProperty(DAMAGE, (Number)Float.valueOf(this.damage));
        object.addProperty(MODE, this.mode.toString());
        object.addProperty(COOLDOWN, (Number)this.cooldown);
        object.addProperty(DELAY, (Number)this.delay);
        object.addProperty(DISTANCE, (Number)Float.valueOf(this.distance));
        object.addProperty(KNOCKBACK, (Number)Float.valueOf(this.knockback));
        object.addProperty(MAX_TARGETS, (Number)this.maxTargets);
        object.addProperty(ATTACK_RADIUS, (Number)Float.valueOf(this.angle));
        return object;
    }

    public Melee copy() {
        Melee projectile = new Melee();
        projectile.damage = this.damage;
        projectile.mode = this.mode;
        projectile.cooldown = this.cooldown;
        projectile.delay = this.delay;
        projectile.distance = this.distance;
        projectile.knockback = this.knockback;
        projectile.maxTargets = this.maxTargets;
        projectile.angle = this.angle;
        return projectile;
    }

    public float getDamage() {
        return this.damage;
    }

    public MeleeMode getMode() {
        return this.mode;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public int getMaxTargets() {
        return this.maxTargets;
    }

    public float getAngle() {
        return this.angle;
    }

    public static Melee create(CompoundTag tag) {
        Melee general = new Melee();
        general.deserializeNBT(tag);
        return general;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Projectile");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final Melee projectile;

        private Builder() {
            this.projectile = new Melee();
        }

        private Builder(Melee projectile) {
            this.projectile = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Melee projectile) {
            return new Builder(projectile);
        }

        public Melee build() {
            return this.projectile.copy();
        }

        public Builder setDamage(ResourceLocation id, float damage) {
            this.projectile.damage = damage;
            return this;
        }

        public Builder setDistance(float distance) {
            this.projectile.distance = distance;
            return this;
        }

        public Builder setKnockback(float knockback) {
            this.projectile.knockback = knockback;
            return this;
        }

        public Builder setMaxTargets(int maxTargets) {
            this.projectile.maxTargets = maxTargets;
            return this;
        }

        public Builder setAttackRadius(float attackRadius) {
            this.projectile.angle = attackRadius;
            return this;
        }
    }
}

