/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class Modules
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    @Optional
    boolean attachmentScreen = true;
    @Optional
    private LinkedHashMap<AttachmentType, ArrayList<Attachment>> attachments = new LinkedHashMap();

    public boolean attachmentScreen() {
        return this.attachmentScreen;
    }

    public LinkedHashMap<AttachmentType, ArrayList<Attachment>> getAttachments() {
        return this.attachments;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Modules");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("AttachmentScreen", this.attachmentScreen);
        if (this.attachments != null && !this.attachments.isEmpty()) {
            tag.m_128365_("Attachments", (Tag)NbtUtils.serializeArrayMap(this.attachments));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("AttachmentScreen", 1)) {
            this.attachmentScreen = tag.m_128471_("AttachmentScreen");
        }
        if (tag.m_128425_("Attachments", 10)) {
            CompoundTag nbt = tag.m_128469_("Attachments");
            this.attachments = NbtUtils.deserializeAttachmentMap(nbt);
        }
    }

    public JsonObject toJsonObject() {
        return new JsonObject();
    }

    public Modules copy() {
        Modules modules = new Modules();
        modules.attachments = new LinkedHashMap<AttachmentType, ArrayList<Attachment>>(this.attachments);
        return modules;
    }

    public static class Attachment
    implements INBTSerializable<CompoundTag> {
        public static final String OFFSET = "Offset";
        @Optional
        @Nullable
        String name;
        @Optional
        @Nullable
        ResourceLocation item;
        @Optional
        ArrayList<String> hide = new ArrayList();
        @Optional
        ArrayList<String> bones = new ArrayList();
        @Optional
        Vec3 offset = Vec3.f_82478_;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.name != null) {
                tag.m_128359_("Name", this.name);
            }
            if (this.item != null) {
                tag.m_128359_("Item", this.item.toString());
            }
            if (this.hide != null) {
                tag.m_128365_("Hide", (Tag)NbtUtils.serializeStringArray(this.hide));
            }
            if (this.bones != null) {
                tag.m_128365_("Bones", (Tag)NbtUtils.serializeStringArray(this.bones));
            }
            tag.m_128365_(OFFSET, (Tag)NbtUtils.writeVec3(this.offset));
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Name", 8)) {
                this.name = tag.m_128461_("Name");
            }
            if (tag.m_128425_("Item", 8)) {
                this.item = ResourceLocation.m_135820_((String)tag.m_128461_("Item"));
            }
            if (tag.m_128425_("Hide", 10)) {
                this.hide = NbtUtils.deserializeStringArray(tag.m_128469_("Hide"));
            }
            if (tag.m_128425_("Bones", 10)) {
                this.bones = NbtUtils.deserializeStringArray(tag.m_128469_("Bones"));
            }
            if (tag.m_128425_(OFFSET, 10)) {
                this.offset = NbtUtils.readVec3(tag.m_128469_(OFFSET));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.name != null) {
                object.addProperty("Name", this.name);
            }
            if (this.item != null) {
                object.addProperty("Item", this.item.toString());
            }
            return object;
        }

        public Attachment copy() {
            Attachment attachments = new Attachment();
            if (this.name != null) {
                attachments.name = this.name;
            }
            if (this.item != null) {
                attachments.item = this.item;
            }
            if (this.hide != null) {
                attachments.hide = this.hide;
            }
            if (this.bones != null) {
                attachments.bones = this.bones;
            }
            attachments.offset = this.offset;
            return attachments;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public ResourceLocation getItemId() {
            return this.item;
        }

        public ArrayList<String> getHidden() {
            return this.hide;
        }

        public ArrayList<String> getBones() {
            return this.bones;
        }

        public Vec3 getOffset() {
            return this.offset;
        }
    }
}

