/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AmmoHolder
extends ResourceHolder {
    private static final Map<ResourceLocation, AmmoHolder> ammoTypeMap = new HashMap<ResourceLocation, AmmoHolder>();
    private boolean canReturnAmmo = false;
    private Function<ItemStack, Boolean> isAcceptable = stack -> false;
    private Function<ItemStack, Integer> getValue = stack -> 1;
    private BiFunction<ItemStack, Integer, List<ItemStack>> onConsume = (stack, i) -> List.of();
    private Function<AmmoHolder, String> getDescriptionId = ammo -> "info." + ammo.id.m_135827_() + "." + ammo.id.m_135815_();

    public AmmoHolder(ResourceLocation id) {
        super(id);
    }

    public boolean canReturnAmmo() {
        return this.canReturnAmmo;
    }

    public boolean isAcceptable(ItemStack ammoStack) {
        return this.isAcceptable.apply(ammoStack);
    }

    public int getValue(ItemStack ammoStack) {
        return this.getValue.apply(ammoStack);
    }

    public BiFunction<ItemStack, Integer, List<ItemStack>> onConsume() {
        return this.onConsume;
    }

    public String getDescriptionId() {
        return this.getDescriptionId.apply(this);
    }

    public static void registerType(AmmoHolder mode) {
        ammoTypeMap.putIfAbsent(mode.getId(), mode);
    }

    public static AmmoHolder getType(String id) {
        return AmmoHolder.getType(ResourceLocation.m_135820_((String)id));
    }

    public static AmmoHolder getType(ResourceLocation id) {
        return ammoTypeMap.getOrDefault(id, AmmoHolder.createDefault(id));
    }

    private static AmmoHolder createDefault(ResourceLocation id) {
        AmmoHolder holder = Builder.create(id).isAcceptable((ItemStack stack) -> Objects.equals(AmmoHolder.getKey(stack), id)).value(s -> 1).descriptionId(ammo -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(ammo.getId());
            if (item != null) {
                return item.m_5524_();
            }
            return "---";
        }).canReturnAmmo().build();
        AmmoHolder.registerType(holder);
        return holder;
    }

    @Nullable
    private static ResourceLocation getKey(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
    }

    public static class Builder {
        private final AmmoHolder holder;

        public Builder(AmmoHolder holder) {
            this.holder = holder;
        }

        public static Builder create(ResourceLocation id) {
            AmmoHolder holder = new AmmoHolder(id);
            return new Builder(holder);
        }

        public Builder isAcceptable(Function<ItemStack, Boolean> isAcceptable) {
            this.holder.isAcceptable = isAcceptable;
            return this;
        }

        public Builder value(Function<ItemStack, Integer> getValue) {
            this.holder.getValue = getValue;
            return this;
        }

        public Builder onConsume(BiFunction<ItemStack, Integer, List<ItemStack>> onConsume) {
            this.holder.onConsume = onConsume;
            return this;
        }

        public Builder descriptionId(Function<AmmoHolder, String> getValue) {
            this.holder.getDescriptionId = getValue;
            return this;
        }

        public Builder canReturnAmmo() {
            this.holder.canReturnAmmo = true;
            return this;
        }

        public AmmoHolder build() {
            return this.holder;
        }
    }
}

