/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.properties;

import com.google.gson.JsonObject;
import com.nukateam.ntgl.client.util.helpers.Easings;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugEnum;
import com.nukateam.ntgl.common.debug.screen.widget.DebugToggle;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class SightAnimation
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final SightAnimation DEFAULT = new SightAnimation();
    @Optional
    protected Easings viewportCurve = Easings.LINEAR;
    @Optional
    protected Easings sightCurve = Easings.EASE_OUT_QUAD;
    @Optional
    protected Easings fovCurve = Easings.LINEAR;
    @Optional
    protected Easings aimTransformCurve = Easings.EASE_IN_QUAD;

    public Easings getViewportCurve() {
        return this.viewportCurve;
    }

    public Easings getSightCurve() {
        return this.sightCurve;
    }

    public Easings getFovCurve() {
        return this.fovCurve;
    }

    public Easings getAimTransformCurve() {
        return this.aimTransformCurve;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Sight Animation");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Debug: ").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}).m_7220_((Component)Component.m_237113_((String)"Force Aim").m_130940_(ChatFormatting.WHITE)), () -> new DebugToggle(Debug.isForceAim(), Debug::setForceAim)));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Viewport Curve"), () -> new DebugEnum<Easings>(Easings.class, this.viewportCurve, value -> {
                this.viewportCurve = value;
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Sight Curve"), () -> new DebugEnum<Easings>(Easings.class, this.sightCurve, value -> {
                this.sightCurve = value;
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"FOV Curve"), () -> new DebugEnum<Easings>(Easings.class, this.fovCurve, value -> {
                this.fovCurve = value;
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Aim Transform Curve"), () -> new DebugEnum<Easings>(Easings.class, this.aimTransformCurve, value -> {
                this.aimTransformCurve = value;
            })));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ViewportCurve", this.viewportCurve.name().toLowerCase(Locale.ROOT));
        tag.m_128359_("SightCurve", this.sightCurve.name().toLowerCase(Locale.ROOT));
        tag.m_128359_("FovCurve", this.fovCurve.name().toLowerCase(Locale.ROOT));
        tag.m_128359_("AimTransformCurve", this.aimTransformCurve.name().toLowerCase(Locale.ROOT));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("ViewportCurve", 8)) {
            this.viewportCurve = Easings.byName(tag.m_128461_("ViewportCurve"));
        }
        if (tag.m_128425_("SightCurve", 8)) {
            this.sightCurve = Easings.byName(tag.m_128461_("SightCurve"));
        }
        if (tag.m_128425_("FovCurve", 8)) {
            this.fovCurve = Easings.byName(tag.m_128461_("FovCurve"));
        }
        if (tag.m_128425_("AimTransformCurve", 8)) {
            this.aimTransformCurve = Easings.byName(tag.m_128461_("AimTransformCurve"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        if (this.viewportCurve != Easings.LINEAR) {
            object.addProperty("viewportCurve", this.viewportCurve.getName());
        }
        if (this.sightCurve != Easings.EASE_OUT_QUAD) {
            object.addProperty("sightCurve", this.sightCurve.getName());
        }
        if (this.fovCurve != Easings.LINEAR) {
            object.addProperty("fovCurve", this.fovCurve.getName());
        }
        if (this.aimTransformCurve != Easings.EASE_IN_QUAD) {
            object.addProperty("aimTransformCurve", this.aimTransformCurve.getName());
        }
        return object;
    }

    public SightAnimation copy() {
        SightAnimation sightAnimation = new SightAnimation();
        sightAnimation.viewportCurve = this.viewportCurve;
        sightAnimation.sightCurve = this.sightCurve;
        sightAnimation.fovCurve = this.fovCurve;
        sightAnimation.aimTransformCurve = this.aimTransformCurve;
        return sightAnimation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SightAnimation sightAnimation = new SightAnimation();

        protected Builder() {
        }

        public Builder setViewportCurve(Easings viewportCurve) {
            this.sightAnimation.viewportCurve = viewportCurve;
            return this;
        }

        public Builder setSightCurve(Easings sightCurve) {
            this.sightAnimation.sightCurve = sightCurve;
            return this;
        }

        public Builder setFovCurve(Easings fovCurve) {
            this.sightAnimation.fovCurve = fovCurve;
            return this;
        }

        public Builder setAimTransformCurve(Easings aimTransformCurve) {
            this.sightAnimation.aimTransformCurve = aimTransformCurve;
            return this;
        }

        public SightAnimation build() {
            return this.sightAnimation.copy();
        }
    }
}

