/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.debug;

import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class Debug {
    private static final Map<IWeapon, WeaponConfig> GUNS = new HashMap<IWeapon, WeaponConfig>();
    private static final Map<Item, Scope> SCOPES = new HashMap<Item, Scope>();
    private static boolean forceAim = false;

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        event.getServer().execute(() -> {
            GUNS.clear();
            SCOPES.clear();
        });
    }

    public static WeaponConfig getGun(IWeapon item) {
        return GUNS.computeIfAbsent(item, item1 -> ((WeaponConfig)item.getConfig()).copy());
    }

    public static Scope getScope(ScopeItem item) {
        return SCOPES.computeIfAbsent(item, item1 -> ((Scope)item.getProperties()).copy());
    }

    public static boolean isForceAim() {
        return forceAim;
    }

    public static void setForceAim(boolean forceAim) {
        Debug.forceAim = forceAim;
    }
}

