/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class S2CMessageReload
implements IMessage<S2CMessageReload> {
    private boolean reload;
    private boolean isRightHand;

    public S2CMessageReload() {
    }

    public S2CMessageReload(boolean reload, InteractionHand arm) {
        this.reload = reload;
        this.isRightHand = arm == InteractionHand.MAIN_HAND;
    }

    public S2CMessageReload(boolean reload, boolean isRightHand) {
        this.reload = reload;
        this.isRightHand = isRightHand;
    }

    @Override
    public void encode(S2CMessageReload message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.reload);
        buffer.writeBoolean(message.isRightHand);
    }

    @Override
    public S2CMessageReload decode(FriendlyByteBuf buffer) {
        return new S2CMessageReload(buffer.readBoolean(), buffer.readBoolean());
    }

    @Override
    public void handle(S2CMessageReload message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> ClientPlayHandler.handleReload(message));
        supplier.setPacketHandled(true);
    }

    public boolean isReload() {
        return this.reload;
    }

    public boolean isRightHand() {
        return this.isRightHand;
    }
}

