/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.google.common.collect.ImmutableMap;
import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.network.IMessage;
import com.nukateam.ntgl.modules.datapack.managers.NetworkWeaponManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class S2CMessageUpdateWeapons
implements IMessage<S2CMessageUpdateWeapons> {
    private ImmutableMap<ResourceLocation, WeaponConfig> registeredGuns;

    @Override
    public void encode(S2CMessageUpdateWeapons message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkWeaponManager.get()));
        NetworkWeaponManager.get().writeRegisteredGuns(buffer);
    }

    @Override
    public S2CMessageUpdateWeapons decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateWeapons message = new S2CMessageUpdateWeapons();
        message.registeredGuns = NetworkWeaponManager.readRegisteredWeapons(buffer);
        return message;
    }

    @Override
    public void handle(S2CMessageUpdateWeapons message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> ClientPlayHandler.handleUpdateWeapons(message));
        supplier.setPacketHandled(true);
    }

    public ImmutableMap<ResourceLocation, WeaponConfig> getRegisteredGuns() {
        return this.registeredGuns;
    }
}

