/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.gunpack.resource;

import com.nukateam.ntgl.modules.gunpack.resource.NTGLPackResources;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NTGLPackManager {
    private static final List<Path> RESOURCE_PACKS = new ArrayList<Path>();
    private static final List<Path> DATA_PACKS = new ArrayList<Path>();

    public static void scanPacks() {
        Path packsDir = FMLPaths.GAMEDIR.get().resolve("ntgl");
        try {
            if (!Files.exists(packsDir, new LinkOption[0])) {
                Files.createDirectories(packsDir, new FileAttribute[0]);
            }
            RESOURCE_PACKS.clear();
            DATA_PACKS.clear();
            Files.list(packsDir).forEach(NTGLPackManager::processPack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processPack(Path packPath) {
        try {
            boolean isZip = Files.isRegularFile(packPath, new LinkOption[0]) && packPath.toString().endsWith(".zip");
            boolean isFolder = Files.isDirectory(packPath, new LinkOption[0]);
            if (!isZip && !isFolder) {
                return;
            }
            FileSystem fs = isZip ? FileSystems.newFileSystem(packPath, (ClassLoader)null) : FileSystems.getDefault();
            Path root = isZip ? fs.getPath("/", new String[0]) : packPath;
            boolean hasAssets = Files.exists(root.resolve("assets"), new LinkOption[0]);
            boolean hasData = Files.exists(root.resolve("data"), new LinkOption[0]);
            if (hasAssets) {
                RESOURCE_PACKS.add(packPath);
            }
            if (hasData) {
                DATA_PACKS.add(packPath);
            }
            if (isZip) {
                fs.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void addResourcePacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            NTGLPackManager.addPacks(event, RESOURCE_PACKS, "assets");
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            NTGLPackManager.addPacks(event, DATA_PACKS, "data");
        }
    }

    private static void addPacks(AddPackFindersEvent event, List<Path> packs, String type) {
        for (Path packPath : packs) {
            Pack.ResourcesSupplier supplier = packId -> {
                try {
                    return new NTGLPackResources(packPath, type, packId);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create pack resources for " + String.valueOf(packPath), e);
                }
            };
            Pack.Info packInfo = Pack.m_246334_((String)("ntgl/" + String.valueOf(packPath.getFileName())), (Pack.ResourcesSupplier)supplier);
            if (packInfo == null) continue;
            Pack pack = Pack.m_245512_((String)("ntgl/" + String.valueOf(packPath.getFileName())), (Component)Component.m_237113_((String)("NTGL Pack: " + String.valueOf(packPath.getFileName()))), (boolean)true, (Pack.ResourcesSupplier)supplier, (Pack.Info)packInfo, (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }
}

