/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.registry.TooltipRegistries;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.element.frame.TooltipFrame;
import dev.obscuria.tooltips.client.tooltip.element.icon.TooltipIcon;
import dev.obscuria.tooltips.client.tooltip.element.panel.TooltipPanel;
import dev.obscuria.tooltips.client.tooltip.element.slot.TooltipSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Unmodifiable;

public record TooltipStyle(Optional<TooltipPanel> panel, Optional<TooltipFrame> frame, Optional<TooltipSlot> slot, Optional<TooltipIcon> icon, @Unmodifiable List<TooltipEffect> effects) {
    public static final TooltipStyle EMPTY = new TooltipStyle(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of());
    public static final Codec<TooltipStyle> DIRECT_CODEC;
    public static final Codec<TooltipStyle> CODEC;

    public TooltipStyle merge(TooltipStyle other) {
        return new TooltipStyle(this.panel.or(other::panel), this.frame.or(other::frame), this.slot.or(other::slot), this.icon.or(other::icon), this.mergeEffects(other.effects));
    }

    private List<TooltipEffect> mergeEffects(List<TooltipEffect> other) {
        if (this.effects.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this.effects;
        }
        ArrayList<TooltipEffect> result = new ArrayList<TooltipEffect>(this.effects);
        for (TooltipEffect effect : other) {
            if (!effect.canApply(result)) continue;
            result.add(effect);
        }
        return result;
    }

    static {
        CODEC = TooltipRegistries.Resource.TOOLTIP_STYLE.byNameCodec();
        DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TooltipPanel.CODEC.optionalFieldOf("panel").forGetter(TooltipStyle::panel), (App)TooltipFrame.CODEC.optionalFieldOf("frame").forGetter(TooltipStyle::frame), (App)TooltipSlot.CODEC.optionalFieldOf("slot").forGetter(TooltipStyle::slot), (App)TooltipIcon.CODEC.optionalFieldOf("icon").forGetter(TooltipStyle::icon), (App)TooltipEffect.CODEC.listOf().fieldOf("effects").forGetter(TooltipStyle::effects)).apply((Applicative)codec, TooltipStyle::new));
    }
}

