/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;

public record ItemOrTagFilter(List<TagKey<Item>> tags, List<Item> items) implements ItemFilter
{
    public static final Codec<ItemOrTagFilter> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ExtraCodecs.f_216161_.listOf().fieldOf("values").forGetter(ItemOrTagFilter::pack)).apply((Applicative)codec, ItemOrTagFilter::unpack));

    public Codec<ItemOrTagFilter> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(ItemStack stack) {
        if (this.items.contains(stack.m_41720_())) return true;
        if (!this.tags.stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) return false;
        return true;
    }

    private List<ExtraCodecs.TagOrElementLocation> pack() {
        return Stream.concat(this.tags.stream().map(ItemOrTagFilter::packTag), this.items.stream().map(ItemOrTagFilter::packItem)).toList();
    }

    private static ExtraCodecs.TagOrElementLocation packTag(TagKey<Item> tag) {
        return new ExtraCodecs.TagOrElementLocation(tag.f_203868_(), true);
    }

    private static ExtraCodecs.TagOrElementLocation packItem(Item item) {
        return new ExtraCodecs.TagOrElementLocation(item.m_204114_().m_205785_().m_135782_(), false);
    }

    private static ItemOrTagFilter unpack(List<ExtraCodecs.TagOrElementLocation> packed) {
        ArrayList tags = Lists.newArrayList();
        ArrayList items = Lists.newArrayList();
        for (ExtraCodecs.TagOrElementLocation location : packed) {
            if (location.f_216196_()) {
                tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location.f_216195_()));
                continue;
            }
            items.add((Item)BuiltInRegistries.f_257033_.m_7745_(location.f_216195_()));
        }
        return new ItemOrTagFilter(tags, items);
    }
}

