/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.config;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.fragmentum.util.color.Colors;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;

public enum ARGBDelegate implements StringRepresentable
{
    DEFAULT_PANEL_BACKGROUND_TOP(() -> ClientConfig.DEFAULT_PANEL_BACKGROUND_TOP.get()),
    DEFAULT_PANEL_BACKGROUND_BOTTOM(() -> ClientConfig.DEFAULT_PANEL_BACKGROUND_BOTTOM.get()),
    DEFAULT_PANEL_BORDER_TOP(() -> ClientConfig.DEFAULT_PANEL_BORDER_TOP.get()),
    DEFAULT_PANEL_BORDER_BOTTOM(() -> ClientConfig.DEFAULT_PANEL_BORDER_BOTTOM.get()),
    UNCOMMON_PANEL_BACKGROUND_TOP(() -> ClientConfig.UNCOMMON_PANEL_BACKGROUND_TOP.get()),
    UNCOMMON_PANEL_BACKGROUND_BOTTOM(() -> ClientConfig.UNCOMMON_PANEL_BACKGROUND_BOTTOM.get()),
    UNCOMMON_PANEL_BORDER_TOP(() -> ClientConfig.UNCOMMON_PANEL_BORDER_TOP.get()),
    UNCOMMON_PANEL_BORDER_BOTTOM(() -> ClientConfig.UNCOMMON_PANEL_BORDER_BOTTOM.get()),
    RARE_PANEL_BACKGROUND_TOP(() -> ClientConfig.RARE_PANEL_BACKGROUND_TOP.get()),
    RARE_PANEL_BACKGROUND_BOTTOM(() -> ClientConfig.RARE_PANEL_BACKGROUND_BOTTOM.get()),
    RARE_PANEL_BORDER_TOP(() -> ClientConfig.RARE_PANEL_BORDER_TOP.get()),
    RARE_PANEL_BORDER_BOTTOM(() -> ClientConfig.RARE_PANEL_BORDER_BOTTOM.get()),
    EPIC_PANEL_BACKGROUND_TOP(() -> ClientConfig.EPIC_PANEL_BACKGROUND_TOP.get()),
    EPIC_PANEL_BACKGROUND_BOTTOM(() -> ClientConfig.EPIC_PANEL_BACKGROUND_BOTTOM.get()),
    EPIC_PANEL_BORDER_TOP(() -> ClientConfig.EPIC_PANEL_BORDER_TOP.get()),
    EPIC_PANEL_BORDER_BOTTOM(() -> ClientConfig.EPIC_PANEL_BORDER_BOTTOM.get()),
    EPIC_RAY_GLOW_PRIMARY(() -> ClientConfig.EPIC_RAY_GLOW_PRIMARY.get()),
    EPIC_RAY_GLOW_SECONDARY(() -> ClientConfig.EPIC_RAY_GLOW_SECONDARY.get()),
    EPIC_SHIMMER_INNER(() -> ClientConfig.EPIC_SHIMMER_INNER.get()),
    EPIC_SHIMMER_OUTER(() -> ClientConfig.EPIC_SHIMMER_OUTER.get()),
    EPIC_SHIMMER_ACCENT(() -> ClientConfig.EPIC_SHIMMER_ACCENT.get()),
    ENCHANTED_PARTICLE_CENTER(() -> ClientConfig.ENCHANTED_PARTICLE_CENTER.get()),
    ENCHANTED_PARTICLE_EDGE(() -> ClientConfig.ENCHANTED_PARTICLE_EDGE.get()),
    ENCHANTED_GLINT_PRIMARY_WAVE(() -> ClientConfig.ENCHANTED_GLINT_PRIMARY_WAVE.get()),
    ENCHANTED_GLINT_PRIMARY_WAVE_GLOW(() -> ClientConfig.ENCHANTED_GLINT_PRIMARY_WAVE_GLOW.get()),
    ENCHANTED_GLINT_SECONDARY_WAVE(() -> ClientConfig.ENCHANTED_GLINT_SECONDARY_WAVE.get()),
    ENCHANTED_GLINT_SECONDARY_WAVE_GLOW(() -> ClientConfig.ENCHANTED_GLINT_SECONDARY_WAVE_GLOW.get()),
    ENCHANTED_GLINT_RING(() -> ClientConfig.ENCHANTED_GLINT_RING.get()),
    CURSED_PARTICLE_CENTER(() -> ClientConfig.CURSED_PARTICLE_CENTER.get()),
    CURSED_PARTICLE_EDGE(() -> ClientConfig.CURSED_PARTICLE_EDGE.get()),
    CURSED_GLINT_PRIMARY_WAVE(() -> ClientConfig.CURSED_GLINT_PRIMARY_WAVE.get()),
    CURSED_GLINT_PRIMARY_WAVE_GLOW(() -> ClientConfig.CURSED_GLINT_PRIMARY_WAVE_GLOW.get()),
    CURSED_GLINT_SECONDARY_WAVE(() -> ClientConfig.CURSED_GLINT_SECONDARY_WAVE.get()),
    CURSED_GLINT_SECONDARY_WAVE_GLOW(() -> ClientConfig.CURSED_GLINT_SECONDARY_WAVE_GLOW.get()),
    CURSED_GLINT_RING(() -> ClientConfig.CURSED_GLINT_RING.get());

    public static final Codec<ARGBDelegate> CODEC;
    public static final ARGB FALLBACK;
    private final Supplier<String> valueProvider;
    private final AtomicReference<String> lastValue = new AtomicReference<String>("");
    private final AtomicReference<ARGB> cachedColor = new AtomicReference<ARGB>(Colors.argbOf((String)"#FFFFFFFF"));

    private ARGBDelegate(Supplier<String> valueProvider) {
        this.valueProvider = valueProvider;
    }

    public ARGB color() {
        String value = this.valueProvider.get();
        if (!value.equals(this.lastValue.get())) {
            this.lastValue.set(value);
            try {
                this.cachedColor.set(Colors.argbOf((String)value));
            }
            catch (Exception exception) {
                ObscureTooltips.LOGGER.warn("Invalid color value `{}` in config entry `{}`. Falling back to default color.", new Object[]{value, this.m_7912_(), exception});
                this.cachedColor.set(FALLBACK);
            }
        }
        return this.cachedColor.get();
    }

    public String m_7912_() {
        return "@" + this;
    }

    static {
        CODEC = StringRepresentable.m_216439_(ARGBDelegate::values);
        FALLBACK = Colors.argbOf((String)"#FFFFFFFF");
    }
}

