/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.container;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.init.ModMenuTypes;
import com.tiviacz.pizzadelight.tags.ModTags;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class PizzaMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaBlockEntity blockEntity;
    public ItemStackHandler transistentHandler = this.createTransistentHandler();

    public PizzaMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaMenu.getBlockEntity(inv, data));
    }

    public PizzaMenu(int windowID, Inventory inv, BlockEntity tile) {
        super((MenuType)ModMenuTypes.PIZZA.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaBlockEntity)tile;
        this.addIngredientsSlots();
        this.addSauceSlot();
        this.addTransistentSlots();
        this.addPlayerInventoryAndHotbar(inv);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 76 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 134));
        }
    }

    public void addTransistentSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.transistentHandler, 0, 35, 10){

            public int m_5866_(@Nonnull ItemStack stack) {
                return 1;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.transistentHandler, 1, 35, 46){

            public int m_5866_(@Nonnull ItemStack stack) {
                return 1;
            }
        });
    }

    public void addIngredientsSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), j + i * 3, 62 + j * 18, 10 + i * 18){

                    public int m_5866_(@Nonnull ItemStack stack) {
                        return 1;
                    }
                });
            }
        }
    }

    public void addSauceSlot() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 9, 125, 20){

            public int m_5866_(@Nonnull ItemStack stack) {
                return 1;
            }

            public boolean m_8010_(Player playerIn) {
                return false;
            }

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }
        });
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 12 ? !this.m_38903_(itemstack1, 12, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 12, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)new RecipeWrapper((IItemHandlerModifiable)this.transistentHandler));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private static PizzaBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntity instanceof PizzaBlockEntity) {
            return (PizzaBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntity));
    }

    private ItemStackHandler createTransistentHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                PizzaMenu.this.transferStack();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof PotionItem || stack.m_204117_(ModTags.SAUCE);
            }
        };
    }

    private void transferStack() {
        if (!this.transistentHandler.getStackInSlot(0).m_41619_()) {
            ItemStack sauceStack = this.transistentHandler.getStackInSlot(0);
            ItemStack container = PizzaMenu.getItemStack(sauceStack);
            this.blockEntity.getInventory().setStackInSlot(9, sauceStack);
            this.transistentHandler.setStackInSlot(0, ItemStack.f_41583_);
            this.blockEntity.m_6596_();
            this.transistentHandler.setStackInSlot(1, container);
        }
    }

    public static ItemStack getItemStack(ItemStack sauceStack) {
        ItemStack container = sauceStack.getCraftingRemainingItem();
        boolean isPotion = sauceStack.m_41720_() instanceof PotionItem;
        boolean isSauce = sauceStack.m_41720_() instanceof BowlFoodItem;
        if (container.m_41619_()) {
            if (isPotion) {
                container = new ItemStack((ItemLike)Items.f_42590_);
            } else if (isSauce) {
                container = new ItemStack((ItemLike)Items.f_42399_);
            }
        }
        return container;
    }
}

