/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.container;

import com.tiviacz.pizzadelight.blockentity.PizzaStationBlockEntity;
import com.tiviacz.pizzadelight.common.PizzaCalculator;
import com.tiviacz.pizzadelight.container.slots.PizzaStationResultSlot;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.init.ModMenuTypes;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.Utils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;

public class PizzaStationMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaStationBlockEntity blockEntity;
    private String itemName;

    public PizzaStationMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaStationMenu.getBlockEntity(inv, data));
    }

    public PizzaStationMenu(int windowID, Inventory inv, BlockEntity tile) {
        super((MenuType)ModMenuTypes.PIZZA_STATION.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaStationBlockEntity)tile;
        this.addResultSlot();
        this.addBaseSlot();
        this.addSauceSlot();
        this.addIngredientsSlots();
        this.addPlayerInventoryAndHotbar(inv);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 114 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 172));
        }
    }

    public void addResultSlot() {
        this.m_38897_((Slot)new PizzaStationResultSlot(this, (IItemHandler)this.blockEntity.getInventory(), 0, 148, 65));
    }

    public void addBaseSlot() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 1, 12, 77){

            public void m_6654_() {
                super.m_6654_();
                PizzaStationMenu.this.updateOutput();
            }
        });
    }

    public void addSauceSlot() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 2, 12, 54){

            public void m_6654_() {
                super.m_6654_();
                PizzaStationMenu.this.updateOutput();
            }
        });
    }

    public void addIngredientsSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 3 + (j + i * 3), 55 + j * 18, 47 + i * 18){

                    public void m_6654_() {
                        super.m_6654_();
                        PizzaStationMenu.this.updateOutput();
                    }
                });
            }
        }
    }

    public void updateOutput() {
        int i;
        ItemStackHandler handler = this.blockEntity.getInventory();
        ItemStack baseStack = handler.getStackInSlot(1);
        ItemStack sauceCopy = handler.getStackInSlot(2).m_41777_();
        sauceCopy.m_41764_(1);
        if (baseStack.m_41619_()) {
            this.resetOutput();
            return;
        }
        ItemStackHandler ingredientsHandler = new ItemStackHandler(10);
        if (!(sauceCopy.m_41619_() || sauceCopy.m_41720_() instanceof PotionItem || sauceCopy.m_204117_(ModTags.SAUCE))) {
            this.resetOutput();
            return;
        }
        int index = 0;
        for (i = 3; i < 12; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            ingredientsHandler.setStackInSlot(index, copy);
            ++index;
        }
        for (i = 0; i < ingredientsHandler.getSlots(); ++i) {
            if (ingredientsHandler.getStackInSlot(i).m_41619_() || ingredientsHandler.getStackInSlot(i).m_41614_()) continue;
            this.resetOutput();
            return;
        }
        if (Utils.isEmpty(ingredientsHandler)) {
            this.resetOutput();
            return;
        }
        ItemStack baseCopy = baseStack.m_41777_();
        baseCopy.m_41764_(1);
        PizzaCalculator calc = new PizzaCalculator(baseCopy, sauceCopy, ingredientsHandler);
        ItemStack result = calc.getResultStackBlock(((Item)ModItems.RAW_PIZZA.get()).m_7968_());
        if (result.m_41619_()) {
            this.resetOutput();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            result.m_41787_();
        } else if (!this.itemName.equals(result.m_41786_().getString())) {
            result.m_41714_((Component)Component.m_237113_((String)this.itemName));
        }
        this.setOutput(result.m_41777_());
    }

    public boolean setItemName(String itemName) {
        String s = PizzaStationMenu.validateName(itemName);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (this.m_38853_(1).m_6657_()) {
                ItemStack itemstack = this.m_38853_(1).m_7993_();
                if (StringUtil.m_14408_((String)s)) {
                    itemstack.m_41787_();
                } else {
                    itemstack.m_41714_((Component)Component.m_237113_((String)s));
                }
            }
            this.updateOutput();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String pItemName) {
        String s = SharedConstants.m_136190_((String)pItemName);
        return s.length() <= 50 ? s : null;
    }

    private void setOutput(ItemStack stack) {
        this.blockEntity.getInventory().setStackInSlot(0, stack);
        this.m_38946_();
    }

    private void resetOutput() {
        ItemStack stack = this.blockEntity.getInventory().getStackInSlot(0);
        if (!stack.m_41619_()) {
            this.setOutput(ItemStack.f_41583_);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 12 ? !this.m_38903_(itemstack1, 12, 48, true) : !this.m_38903_(itemstack1, 0, 12, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private static PizzaStationBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntity instanceof PizzaStationBlockEntity) {
            return (PizzaStationBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntity));
    }
}

