/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.items;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.client.renderer.PizzaWithoutLevelRenderer;
import com.tiviacz.pizzadelight.client.tooltip.PizzaTooltipComponent;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.util.NBTUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class RawPizzaBlockItem
extends BlockItem {
    public RawPizzaBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new PizzaWithoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), () -> new PizzaBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.RAW_PIZZA.get()).m_49966_()));
            }
        });
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        return Optional.of(new PizzaTooltipComponent(pStack));
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity livingEntity) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(NBTUtils.getHunger(stack));
        builder.m_38758_(NBTUtils.getSaturation(stack));
        for (Pair<MobEffectInstance, Float> effect : NBTUtils.getEffects(stack)) {
            builder.effect(() -> effect.getFirst(), ((Float)effect.getSecond()).floatValue());
        }
        ArrayList<ItemStack> foods = new ArrayList<ItemStack>(NBTUtils.getIngredients(stack));
        for (ItemStack food : foods) {
            FoodProperties props = food.getFoodProperties(livingEntity);
            if (props != null) {
                if (props.m_38746_()) {
                    builder.m_38757_();
                }
                for (Pair effect : props.m_38749_()) {
                    builder.effect(() -> ((Pair)effect).getFirst(), ((Float)effect.getSecond()).floatValue());
                }
            }
            if (!(food.m_41720_() instanceof PotionItem)) continue;
            for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)food)) {
                builder.effect(() -> new MobEffectInstance(mobeffectinstance), 1.0f);
            }
        }
        return builder.m_38767_();
    }

    public boolean m_41472_() {
        return false;
    }
}

