/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StorageJarBlockEntity
extends BasicLootBlockEntity {
    private int headIndex = -1;

    public StorageJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.STORAGE_JAR.get(), pos, state);
    }

    public StorageJarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 18);
    }

    private int getHeadIndex() {
        if (this.headIndex == -1 || this.headIndex >= 0 && this.headIndex < this.m_6643_() && !this.m_8020_(this.headIndex).m_41619_()) {
            this.recalculateHeadIndex();
        }
        return this.headIndex;
    }

    private void recalculateHeadIndex() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.headIndex = i;
            return;
        }
        this.headIndex = this.m_6643_();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean addItem(ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        ItemStack filter = this.m_8020_(0);
        if (!filter.m_41619_() && !ItemStack.m_41656_((ItemStack)filter, (ItemStack)stack)) {
            return false;
        }
        int head = this.getHeadIndex();
        if (head < this.m_6643_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            stack.m_41774_(1);
            this.m_6836_(head, copy);
            float percent = (float)this.headIndex / (float)this.m_6643_();
            float pitch = 0.9f + 0.3f * percent;
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_STORAGE_JAR_INSERT_ITEM.get(), SoundSource.BLOCKS, 1.0f, pitch);
            return true;
        }
        return false;
    }

    public void popItem(Direction face) {
        ItemStack stack;
        int index = this.getHeadIndex() - 1;
        if (index >= 0 && index < this.m_6643_() && !(stack = this.m_8020_(index)).m_41619_()) {
            BlockPos pos = this.f_58858_;
            double x = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.35;
            double y = (double)pos.m_123342_() + 0.15;
            double z = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.35;
            ItemEntity entity = new ItemEntity(this.f_58857_, x, y, z, stack.m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            float percent = (float)this.headIndex / (float)this.m_6643_();
            float pitch = 0.9f + 0.3f * percent;
            this.f_58857_.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_STORAGE_JAR_INSERT_ITEM.get(), SoundSource.BLOCKS, 1.0f, pitch);
            stack.m_41764_(0);
            this.headIndex = index;
            this.m_6596_();
        }
    }

    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        if (this.getHeadIndex() > 0 && this.m_8020_(this.getHeadIndex() - 1).m_41619_()) {
            this.recalculateHeadIndex();
        }
        return slotIndex == this.getHeadIndex() - 1;
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack stack) {
        ItemStack filter = this.m_8020_(0);
        if (slotIndex > 0 && !filter.m_41619_() && !ItemStack.m_41656_((ItemStack)filter, (ItemStack)stack)) {
            return false;
        }
        if (slotIndex < this.getHeadIndex() && this.m_8020_(slotIndex).m_41619_()) {
            this.recalculateHeadIndex();
        }
        if (slotIndex > this.getHeadIndex()) {
            return false;
        }
        if (this.getHeadIndex() >= this.m_6643_()) {
            return false;
        }
        return slotIndex <= this.getHeadIndex();
    }

    public void m_6836_(int slotIndex, ItemStack stack) {
        int headIndex = this.getHeadIndex();
        if (slotIndex <= headIndex) {
            super.m_6836_(slotIndex, stack);
            if (!stack.m_41619_()) {
                if (slotIndex == headIndex) {
                    ++this.headIndex;
                }
            } else if (slotIndex == headIndex - 1) {
                --this.headIndex;
            }
        }
    }

    public ItemStack m_7407_(int slotIndex, int count) {
        if (slotIndex == this.getHeadIndex() - 1) {
            ItemStack result = super.m_7407_(slotIndex, count);
            if (this.m_8020_(slotIndex).m_41619_()) {
                --this.headIndex;
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "storage_jar", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return null;
    }

    public void m_6596_() {
        super.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

