/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.forge.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.oxcodsnet.roadarchitect.config.LampPostConfigEntry;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.RoadArchitectConfigData;
import net.oxcodsnet.roadarchitect.config.RoadStyleConfigEntry;
import net.oxcodsnet.roadarchitect.config.defaults.BopRoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.LampPostDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.RoadStyleDefaults;
import net.oxcodsnet.roadarchitect.handlers.RoadPipelineController;
import net.oxcodsnet.roadarchitect.handlers.compat.BopCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RAConfigForgeBridge {
    private static final Logger LOG = LoggerFactory.getLogger((String)"RoadArchitect/ConfigBridge");
    private static ConfigHolder<RoadArchitectConfigData> holder;

    private RAConfigForgeBridge() {
    }

    public static void bootstrap() {
        holder = AutoConfig.register(RoadArchitectConfigData.class, GsonConfigSerializer::new);
        if (!BopCompat.isPresent()) {
            RAConfigForgeBridge.registerBopInstallHint();
        }
        RAConfigHolder.set(new RAConfig(){

            @Override
            public int initScanRadius() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).initScanRadius;
            }

            @Override
            public int chunkGenerateScanRadius() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).chunkGenerateScanRadius;
            }

            @Override
            public int maxConnectionDistance() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).maxConnectionDistance;
            }

            @Override
            public int pipelineIntervalSeconds() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pipelineIntervalSeconds;
            }

            @Override
            public int lampInterval() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).lampInterval;
            }

            @Override
            public int roadWidth() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).roadWidth;
            }

            @Override
            public int buoyInterval() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).buoyInterval;
            }

            @Override
            public int sideDecorationInterval() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).sideDecorationInterval;
            }

            @Override
            public int maskErosion() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).maskErosion;
            }

            @Override
            public boolean deterministicDecorations() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).deterministicDecorations;
            }

            @Override
            public List<String> structureSelectors() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).structureSelectors;
            }

            @Override
            public List<String> dimensionSelectors() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).dimensionSelectors;
            }

            @Override
            public boolean terrainAnalyzerEnabled() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).terrainAnalyzer.enabled;
            }

            @Override
            public int terrainRoughRadius() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).terrainAnalyzer.roughRadius;
            }

            @Override
            public int terrainRoughStride() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).terrainAnalyzer.roughStride;
            }

            @Override
            public int terrainRangeThreshold() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).terrainAnalyzer.roughRangeThreshold;
            }

            @Override
            public double terrainPenaltyScale() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).terrainAnalyzer.roughPenaltyScale;
            }

            @Override
            public boolean preferLandOverWater() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.preferLandOverWater;
            }

            @Override
            public double waterStepPenalty() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.waterStepPenalty;
            }

            @Override
            public int coastAvoidBufferBlocks() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.coastAvoidBufferBlocks;
            }

            @Override
            public double coastProximityPenalty() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.coastProximityPenalty;
            }

            @Override
            public List<String> forbiddenBiomeSelectors() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).forbiddenBiomes.selectors;
            }

            @Override
            public int forbiddenBiomeBufferBlocks() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).forbiddenBiomes.bufferBlocks;
            }

            @Override
            public double forbiddenBiomeProximityPenalty() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).forbiddenBiomes.proximityPenalty;
            }

            @Override
            public boolean acceptPartialPaths() {
                return ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.acceptHighProgressPartial;
            }

            @Override
            public double partialProgressThreshold() {
                int pct = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).pathfinding.partialProgressPercent;
                if (pct <= 0) {
                    return 0.0;
                }
                if (pct >= 100) {
                    return 1.0;
                }
                return (double)pct / 100.0;
            }

            @Override
            public List<LampPostConfigEntry> lampPostOverrides() {
                RoadArchitectConfigData.LampPostSettings settings = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).lampPosts;
                if (settings == null) {
                    return LampPostDefaults.entries();
                }
                if (!settings.enabled) {
                    return LampPostDefaults.entries();
                }
                List<RoadArchitectConfigData.LampPostDefinition> defs = settings.overrides;
                if (defs == null || defs.isEmpty()) {
                    return LampPostDefaults.entries();
                }
                ArrayList<LampPostConfigEntry> out = new ArrayList<LampPostConfigEntry>(defs.size());
                for (RoadArchitectConfigData.LampPostDefinition def : defs) {
                    if (def == null) continue;
                    out.add(new LampPostConfigEntry(def.biomeSelectors, def.baseBlock, def.postBlock, def.lampBlock));
                }
                return List.copyOf(out);
            }

            @Override
            public List<RoadStyleConfigEntry> roadStyleOverrides() {
                RoadArchitectConfigData.RoadStyleSettings settings = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).roadStyles;
                if (settings == null || !settings.enabled) {
                    return RoadStyleDefaults.entries();
                }
                return RAConfigForgeBridge.compileRoadStyles(settings.overrides, RoadStyleDefaults.entries());
            }

            @Override
            public List<RoadStyleConfigEntry> bopRoadStyleOverrides() {
                if (!BopCompat.isPresent()) {
                    return List.of();
                }
                RoadArchitectConfigData.BopRoadStyleSettings settings = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).bopRoadStyles;
                if (settings == null || !settings.enabled) {
                    return BopRoadStyleDefaults.entries();
                }
                return RAConfigForgeBridge.compileRoadStyles(settings.overrides, BopRoadStyleDefaults.entries());
            }

            @Override
            public boolean debugVerboseLogs() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).debug;
                return settings != null && settings.enableVerboseLogs;
            }

            @Override
            public boolean debugPipelineProfiler() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigForgeBridge.holder.getConfig()).debug;
                return settings != null && settings.enablePipelineProfiler;
            }
        });
        RoadPipelineController.refreshStructureSelectorCache();
        LOG.info("[RoadArchitect] cloth-config bridge initialized");
    }

    private static void registerBopInstallHint() {
        try {
            AutoConfig.getGuiRegistry(RoadArchitectConfigData.class).registerPredicateProvider((name, field, config, defaults, registry) -> {
                LOG.warn("Failed to create Cloth Config hint entry for missing Biomes O' Plenty");
                return List.of();
            }, field -> field.getDeclaringClass() == RoadArchitectConfigData.class && field.getType() == RoadArchitectConfigData.BopRoadStyleSettings.class);
        }
        catch (NoSuchMethodError missingGuiRegistry) {
            LOG.warn("Cloth Config gui registry unavailable, skipping Biomes O' Plenty hint registration");
        }
    }

    private static List<RoadStyleConfigEntry> compileRoadStyles(List<RoadArchitectConfigData.RoadStyleDefinition> definitions, List<RoadStyleConfigEntry> defaults) {
        if (definitions == null || definitions.isEmpty()) {
            return defaults;
        }
        ArrayList<RoadStyleConfigEntry> out = new ArrayList<RoadStyleConfigEntry>(definitions.size());
        for (RoadArchitectConfigData.RoadStyleDefinition def : definitions) {
            RoadStyleConfigEntry roadStyleConfigEntry;
            if (def == null) continue;
            ArrayList<RoadStyleConfigEntry.SurfaceBlockEntry> palette = new ArrayList<RoadStyleConfigEntry.SurfaceBlockEntry>();
            if (def.palette != null) {
                for (RoadArchitectConfigData.RoadPaletteEntry roadPaletteEntry : def.palette) {
                    if (roadPaletteEntry == null) continue;
                    palette.add(new RoadStyleConfigEntry.SurfaceBlockEntry(roadPaletteEntry.block, roadPaletteEntry.weight));
                }
            }
            ArrayList<RoadStyleConfigEntry.DecorationEntry> decorations = new ArrayList<RoadStyleConfigEntry.DecorationEntry>();
            if (def.decorations != null) {
                for (RoadArchitectConfigData.RoadDecorationEntry entry2 : def.decorations) {
                    if (entry2 == null) continue;
                    decorations.add(new RoadStyleConfigEntry.DecorationEntry(entry2.type, entry2.block));
                }
            }
            if ((roadStyleConfigEntry = new RoadStyleConfigEntry(def.biomeSelectors, palette, decorations)).palette().isEmpty()) {
                LOG.warn("Skipping road style override with empty palette for selectors {}", def.biomeSelectors);
                continue;
            }
            out.add(roadStyleConfigEntry);
        }
        if (out.isEmpty()) {
            return defaults;
        }
        return List.copyOf(out);
    }
}

