/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PipelineRunner;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPipelineController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadPipelineController.class.getSimpleName()));
    private static final Set<ResourceKey<Level>> INITIALIZED = ConcurrentHashMap.newKeySet();
    private static final Set<ResourceLocation> TARGET_IDS = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Structure>> TARGET_TAGS = new HashSet<TagKey<Structure>>();
    private static final Set<ResourceLocation> TARGET_DIMENSION_IDS = new HashSet<ResourceLocation>();
    private static int tickCounter = 0;

    private RoadPipelineController() {
    }

    public static void init() {
        RoadPipelineController.cacheStructureSelectors();
        tickCounter = 0;
        DebugLog.info(LOGGER, "RoadPipelineController initialized (selectors cached)", new Object[0]);
    }

    public static void refreshStructureSelectorCache() {
        RoadPipelineController.cacheStructureSelectors();
        DebugLog.info(LOGGER, "RoadPipelineController reloaded selectors from config", new Object[0]);
    }

    public static void onSpawnChunkGenerated(ServerLevel world, ChunkAccess chunk) {
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.m_46472_())) {
            return;
        }
        ChunkPos spawnChunk = new ChunkPos(world.m_220360_());
        if (!chunk.m_7697_().equals((Object)spawnChunk)) {
            return;
        }
        if (INITIALIZED.add((ResourceKey<Level>)world.m_46472_())) {
            DebugLog.info(LOGGER, "Spawn chunk {} generated in {}, starting INIT pipeline", chunk.m_7697_(), world.m_46472_().m_135782_());
            PipelineRunner.runPipeline(world, world.m_220360_(), PipelineRunner.PipelineMode.INIT);
        }
    }

    public static void onChunkGenerated(ServerLevel world, ChunkAccess chunk) {
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.m_46472_())) {
            return;
        }
        if (!RoadPipelineController.containsTargetStructure(world, chunk)) {
            return;
        }
        BlockPos center = chunk.m_7697_().m_151394_(0);
        DebugLog.info(LOGGER, "Chunk {} generated with target structure, starting CHUNK pipeline", chunk.m_7697_());
        PipelineRunner.runPipeline(world, center, PipelineRunner.PipelineMode.CHUNK);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.m_46472_())) {
            return;
        }
        BlockPos pos = player.m_20183_();
        DebugLog.info(LOGGER, "Player {} joined at {}, starting PERIODIC pipeline", player.m_7755_().getString(), pos);
        PipelineRunner.runPipeline(world, pos, PipelineRunner.PipelineMode.PERIODIC);
    }

    public static void onServerTick(MinecraftServer server) {
        int intervalTicks = Math.max(1, RoadArchitect.CONFIG.pipelineIntervalSeconds() * 20);
        if (++tickCounter < intervalTicks) {
            return;
        }
        tickCounter = 0;
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            Level w = player.m_9236_();
            if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)w.m_46472_())) continue;
            BlockPos pos = player.m_20183_();
            DebugLog.info(LOGGER, "Periodic trigger at player {} pos {}, starting PERIODIC pipeline", player.m_7755_().getString(), pos);
            PipelineRunner.runPipeline((ServerLevel)w, pos, PipelineRunner.PipelineMode.PERIODIC);
        }
    }

    public static void onServerStopping() {
        INITIALIZED.clear();
        tickCounter = 0;
        DebugLog.info(LOGGER, "Server stopping, state cleared", new Object[0]);
    }

    private static void cacheStructureSelectors() {
        TARGET_IDS.clear();
        TARGET_TAGS.clear();
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        for (String sel : selectors) {
            if (sel.startsWith("#")) {
                ResourceLocation tagId = ResourceLocation.m_135820_((String)sel.substring(1));
                if (tagId == null) {
                    LOGGER.warn("Skipping invalid structure tag selector '{}'", (Object)sel);
                    continue;
                }
                TARGET_TAGS.add((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)tagId));
                continue;
            }
            ResourceLocation id = ResourceLocation.m_135820_((String)sel);
            if (id == null) {
                LOGGER.warn("Skipping invalid structure selector '{}'", (Object)sel);
                continue;
            }
            TARGET_IDS.add(id);
        }
        TARGET_DIMENSION_IDS.clear();
        List<String> dimensionSelectors = RoadArchitect.CONFIG.dimensionSelectors();
        if (dimensionSelectors == null || dimensionSelectors.isEmpty()) {
            TARGET_DIMENSION_IDS.add(Level.f_46428_.m_135782_());
        } else {
            for (String selector : dimensionSelectors) {
                if (selector.startsWith("#")) {
                    LOGGER.warn("Dimension selector tags are not supported (skipping '{}')", (Object)selector);
                    continue;
                }
                ResourceLocation id = ResourceLocation.m_135820_((String)selector);
                if (id == null) {
                    LOGGER.warn("Skipping invalid dimension selector '{}'", (Object)selector);
                    continue;
                }
                TARGET_DIMENSION_IDS.add(id);
            }
            if (TARGET_DIMENSION_IDS.isEmpty()) {
                TARGET_DIMENSION_IDS.add(Level.f_46428_.m_135782_());
            }
        }
    }

    static boolean isDimensionEnabled(ResourceKey<Level> key) {
        if (TARGET_DIMENSION_IDS.isEmpty()) {
            return key == Level.f_46428_;
        }
        return TARGET_DIMENSION_IDS.contains(key.m_135782_());
    }

    private static boolean containsTargetStructure(ServerLevel world, ChunkAccess chunk) {
        if (!chunk.m_187678_()) {
            return false;
        }
        Registry registry = world.m_9598_().m_175515_(Registries.f_256944_);
        for (StructureStart start : chunk.m_6633_().values()) {
            Structure structure = start.m_226861_();
            ResourceLocation id = registry.m_7981_((Object)structure);
            if (id != null && TARGET_IDS.contains(id)) {
                return true;
            }
            Holder entry = registry.m_263177_((Object)structure);
            if (entry == null) continue;
            for (TagKey<Structure> tag : TARGET_TAGS) {
                if (!entry.m_203656_(tag)) continue;
                return true;
            }
        }
        return false;
    }
}

