/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeSelectorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/BiomeSelectorUtil");
    private static final Map<Registry<Biome>, Map<String, HolderSet<Biome>>> CACHE = new ConcurrentHashMap<Registry<Biome>, Map<String, HolderSet<Biome>>>();

    private BiomeSelectorUtil() {
    }

    public static List<HolderSet<Biome>> compile(Registry<Biome> registry, List<String> selectors) {
        Map local = CACHE.computeIfAbsent(registry, r -> new ConcurrentHashMap());
        ResourceOrTagKeyArgument argType = new ResourceOrTagKeyArgument(Registries.f_256952_);
        ArrayList<HolderSet<Biome>> compiled = new ArrayList<HolderSet<Biome>>(selectors.size());
        for (String raw : selectors) {
            HolderSet list;
            block5: {
                if (raw == null || raw.isBlank()) continue;
                list = (HolderSet)local.get(raw);
                if (list == null) {
                    try {
                        ResourceOrTagKeyArgument.Result predicate = argType.parse(new StringReader(raw));
                        HolderSet parsed = ((Optional)predicate.m_245276_().map(key -> registry.m_203636_(key).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> registry.m_203431_(arg_0))).orElse(null);
                        if (parsed != null) {
                            HolderSet prev = local.putIfAbsent(raw, parsed);
                            list = prev != null ? prev : parsed;
                            break block5;
                        }
                        LOGGER.warn("Biome selector '{}' resolved to nothing", (Object)raw);
                    }
                    catch (CommandSyntaxException ex) {
                        LOGGER.warn("Biome selector '{}' is invalid: {}", (Object)raw, (Object)ex.getMessage());
                    }
                    continue;
                }
            }
            compiled.add((HolderSet<Biome>)list);
        }
        return compiled;
    }

    public static boolean matches(Holder<Biome> biome, List<HolderSet<Biome>> lists) {
        for (HolderSet<Biome> list : lists) {
            if (!list.m_203333_(biome)) continue;
            return true;
        }
        return false;
    }
}

